"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointExceptionsGenerator = void 0;
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _artifact_list_item_entry_values = require("./common/artifact_list_item_entry_values");
var _exceptions_list_item_generator = require("./exceptions_list_item_generator");
var _base_data_generator = require("./base_data_generator");
var _artifacts = require("../service/artifacts");
var _alerts_ecs_fields = require("./common/alerts_ecs_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EndpointExceptionsGenerator extends _base_data_generator.BaseDataGenerator {
  generate(overrides = {}) {
    return {
      name: `Generated Exception (${this.randomString(5)})`,
      comments: [],
      description: 'created by EndpointExceptionsGenerator',
      id: this.seededUUIDv4(),
      item_id: this.seededUUIDv4(),
      list_id: _securitysolutionListConstants.ENDPOINT_LIST_ID,
      tags: [_artifacts.GLOBAL_ARTIFACT_TAG],
      entries: this.randomEndpointExceptionEntries(1),
      meta: undefined,
      namespace_type: 'agnostic',
      os_types: [this.randomOSFamily()],
      created_at: this.randomPastDate(),
      created_by: this.randomUser(),
      updated_at: '2020-04-20T15:25:31.830Z',
      expire_time: undefined,
      updated_by: this.randomUser(),
      _version: this.randomString(5),
      type: 'simple',
      tie_breaker_id: this.seededUUIDv4(),
      ...overrides
    };
  }
  generateEndpointExceptionForCreate(overrides = {}) {
    return {
      ...(0, _exceptions_list_item_generator.exceptionItemToCreateExceptionItem)(this.generate()),
      ...overrides
    };
  }
  randomEndpointExceptionEntries(count = this.randomN(5)) {
    const operatorTypes = _artifact_list_item_entry_values.LIST_ITEM_ENTRY_OPERATOR_TYPES.filter(item => ![_securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST, _securitysolutionIoTsListTypes.ListOperatorTypeEnum.NESTED, _securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS].includes(item));
    const fieldList = _alerts_ecs_fields.ENDPOINT_EVENTS_LOG_INDEX_FIELDS.filter(field => field.endsWith('.text'));
    return Array.from({
      length: count || 1
    }, () => {
      const operatorType = this.randomChoice(operatorTypes);
      return {
        field: this.randomChoice(fieldList),
        operator: 'included',
        type: operatorType,
        value: operatorType === _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY ? [this.randomString(10), this.randomString(10)] : this.randomString(10)
      };
    });
  }
}
exports.EndpointExceptionsGenerator = EndpointExceptionsGenerator;