"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractRuleSchedule = void 0;
var _time_duration = require("@kbn/securitysolution-utils/time_duration");
var _date_math = require("@kbn/securitysolution-utils/date_math");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractRuleSchedule = rule => {
  var _TimeDuration$parse, _rule$from, _rule$to;
  const interval = (_TimeDuration$parse = _time_duration.TimeDuration.parse(rule.interval)) !== null && _TimeDuration$parse !== void 0 ? _TimeDuration$parse : new _time_duration.TimeDuration(5, 'm');
  const from = (_rule$from = rule.from) !== null && _rule$from !== void 0 ? _rule$from : 'now-6m';
  const to = (_rule$to = rule.to) !== null && _rule$to !== void 0 ? _rule$to : 'now';
  return {
    interval: interval.toString(),
    from: (0, _date_math.normalizeDateMath)(from),
    to: (0, _date_math.normalizeDateMath)(to)
  };
};
exports.extractRuleSchedule = extractRuleSchedule;