"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleTemplateEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _role_template_type_select = require("./role_template_type_select");
var _role_template_type = require("../services/role_template_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleTemplateEditor = ({
  roleTemplate,
  onChange,
  onDelete,
  canUseInlineScripts,
  canUseStoredScripts,
  readOnly = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, getTemplateConfigurationFields(), getEditorForTemplate(), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !readOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "trash",
    color: "danger",
    size: "xs",
    onClick: () => onDelete(roleTemplate),
    "data-test-subj": "deleteRoleTemplateButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.deleteRoleTemplateButton",
    defaultMessage: "Delete template"
  })) : null))));
  function getTemplateFormatSwitch() {
    const returnsJsonLabel = _i18n.i18n.translate('xpack.security.management.editRoleMapping.roleTemplateReturnsJson', {
      defaultMessage: 'Returns JSON'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: returnsJsonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "roleTemplateFormatSwitch",
      checked: roleTemplate.format === 'json',
      label: returnsJsonLabel,
      showLabel: false,
      onChange: e => {
        onChange({
          ...roleTemplate,
          format: e.target.checked ? 'json' : 'string'
        });
      },
      disabled: readOnly
    }));
  }
  function getTemplateConfigurationFields() {
    const templateTypeComboBox = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.roleTemplateType",
        defaultMessage: "Template type"
      })
    }, /*#__PURE__*/_react.default.createElement(_role_template_type_select.RoleTemplateTypeSelect, {
      roleTemplate: roleTemplate,
      canUseStoredScripts: canUseStoredScripts,
      canUseInlineScripts: canUseInlineScripts,
      onChange: onChange,
      readOnly: readOnly
    })));
    const templateFormatSwitch = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, getTemplateFormatSwitch());
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, templateTypeComboBox, templateFormatSwitch));
  }
  function getEditorForTemplate() {
    if ((0, _role_template_type.isInlineRoleTemplate)(roleTemplate)) {
      const extraProps = {};
      if (!canUseInlineScripts && !readOnly) {
        extraProps.isInvalid = true;
        extraProps.error = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          color: "danger",
          "data-test-subj": "roleMappingInlineScriptsDisabled"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleTemplateInlineScriptsDisabled",
          defaultMessage: "Template uses inline scripts, which are disabled in Elasticsearch."
        }));
      }
      const example = '{{username}}_role';
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1,
        style: {
          maxWidth: '400px'
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleTemplateLabel",
          defaultMessage: "Template"
        }),
        helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleTemplateHelpText",
          defaultMessage: "Mustache templates are allowed. Example: {example}",
          values: {
            example
          }
        })
      }, extraProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        "data-test-subj": "roleTemplateSourceEditor",
        value: roleTemplate.template.source,
        onChange: e => {
          onChange({
            ...roleTemplate,
            template: {
              source: e.target.value
            }
          });
        },
        disabled: readOnly
      }))));
    }
    if ((0, _role_template_type.isStoredRoleTemplate)(roleTemplate)) {
      const extraProps = {};
      if (!canUseStoredScripts) {
        extraProps.isInvalid = true;
        extraProps.error = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          color: "danger",
          "data-test-subj": "roleMappingStoredScriptsDisabled"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleTemplateStoredScriptsDisabled",
          defaultMessage: "Template uses stored scripts, which are disabled in Elasticsearch."
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1,
        style: {
          maxWidth: '400px'
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.storedScriptLabel",
          defaultMessage: "Stored script ID"
        }),
        helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.storedScriptHelpText",
          defaultMessage: "ID of a previously stored Painless or Mustache script."
        })
      }, extraProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        "data-test-subj": "roleTemplateScriptIdEditor",
        value: roleTemplate.template.id,
        onChange: e => {
          onChange({
            ...roleTemplate,
            template: {
              id: e.target.value
            }
          });
        },
        disabled: readOnly
      }))));
    }
    if ((0, _role_template_type.isInvalidRoleTemplate)(roleTemplate)) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1,
        "data-test-subj": "roleMappingInvalidRoleTemplate"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.invalidRoleTemplateTitle",
          defaultMessage: "Invalid role template"
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.invalidRoleTemplateMessage",
        defaultMessage: "Role template is invalid, and cannot be edited here. Please delete and recreate, or fix via the Role Mapping API."
      })));
    }
    throw new Error(`Unable to determine role template type`);
  }
};
exports.RoleTemplateEditor = RoleTemplateEditor;