"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchPlaygroundPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _common = require("../common");
var _doc_links = require("../common/doc_links");
var _locators = require("./locators");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SearchPlaygroundPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "licenseSubscription", void 0);
    this.config = initializerContext.config.get();
  }
  setup(core, deps) {
    var _this$config$ui;
    if (!((_this$config$ui = this.config.ui) !== null && _this$config$ui !== void 0 && _this$config$ui.enabled)) return {};
    core.application.register({
      id: _common.PLUGIN_ID,
      appRoute: _common.PLUGIN_PATH,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: 'logoEnterpriseSearch',
      status: _public.AppStatus.inaccessible,
      title: _common.PLUGIN_NAME,
      updater$: this.appUpdater$,
      async mount({
        element,
        history
      }) {
        var _depsStart$searchNavi;
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const [coreStart, depsStart] = await core.getStartServices();
        coreStart.chrome.docTitle.change(_common.PLUGIN_NAME);
        (_depsStart$searchNavi = depsStart.searchNavigation) === null || _depsStart$searchNavi === void 0 ? void 0 : _depsStart$searchNavi.handleOnAppMount();
        const startDeps = {
          ...depsStart,
          history
        };
        return renderApp(coreStart, startDeps, element);
      },
      visibleIn: ['sideNav', 'globalSearch'],
      order: 2
    });
    (0, _locators.registerLocators)(deps.share);
    return {};
  }
  start(core, {
    licensing
  }) {
    _doc_links.docLinks.setDocLinks(core.docLinks.links);
    this.licenseSubscription = licensing.license$.subscribe(license => {
      const status = license && license.isAvailable && license.isActive && license.hasAtLeast('enterprise') ? _public.AppStatus.accessible : _public.AppStatus.inaccessible;
      this.appUpdater$.next(() => ({
        status
      }));
    });
    return {};
  }
  stop() {
    if (this.licenseSubscription) {
      this.licenseSubscription.unsubscribe();
      this.licenseSubscription = undefined;
    }
  }
}
exports.SearchPlaygroundPlugin = SearchPlaygroundPlugin;