"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDocumentsCodeExample = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _tryInConsole = require("@kbn/try-in-console");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _use_kibana = require("../../hooks/use_kibana");
var _language_selector = require("../shared/language_selector");
var _use_ingest_code_examples = require("./hooks/use_ingest_code_examples");
var _use_elasticsearch_url = require("../../hooks/use_elasticsearch_url");
var _usage_tracker_context = require("../../contexts/usage_tracker_context");
var _code_examples = require("../../code_examples");
var _constants = require("../../analytics/constants");
var _code_sample = require("../shared/code_sample");
var _document_generation = require("../../utils/document_generation");
var _language = require("../../utils/language");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddDocumentsCodeExample = ({
  indexName,
  mappingProperties
}) => {
  const {
    application,
    share,
    console: consolePlugin
  } = (0, _use_kibana.useKibana)().services;
  const ingestCodeExamples = (0, _use_ingest_code_examples.useIngestCodeExamples)();
  const elasticsearchUrl = (0, _use_elasticsearch_url.useElasticsearchUrl)();
  const usageTracker = (0, _usage_tracker_context.useUsageTracker)();
  const indexHasMappings = Object.keys(mappingProperties).length > 0;
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)(_language.getDefaultCodingLanguage);
  const selectedCodeExamples = ingestCodeExamples[selectedLanguage];
  const codeSampleMappings = indexHasMappings ? mappingProperties : ingestCodeExamples.defaultMapping;
  const onSelectLanguage = (0, _react.useCallback)(value => {
    setSelectedLanguage(value);
    usageTracker.count([_constants.AnalyticsEvents.startCreateIndexLanguageSelect, `${_constants.AnalyticsEvents.startCreateIndexLanguageSelect}_${value}`]);
  }, [usageTracker]);
  const sampleDocuments = (0, _react.useMemo)(() => {
    return [1, 2, 3].map(num => (0, _document_generation.generateSampleDocument)(codeSampleMappings, `Example text ${num}`));
  }, [codeSampleMappings]);
  const {
    apiKey,
    apiKeyIsVisible
  } = (0, _searchApiKeysComponents.useSearchApiKey)();
  const codeParams = (0, _react.useMemo)(() => {
    return {
      indexName,
      elasticsearchURL: elasticsearchUrl,
      sampleDocuments,
      indexHasMappings,
      mappingProperties: codeSampleMappings,
      apiKey: apiKeyIsVisible && apiKey ? apiKey : undefined
    };
  }, [indexName, elasticsearchUrl, sampleDocuments, codeSampleMappings, indexHasMappings, apiKeyIsVisible, apiKey]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "m",
    "data-test-subj": "SearchIndicesAddDocumentsCode"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      maxWidth: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_language_selector.LanguageSelector, {
    options: _code_examples.LanguageOptions,
    selectedLanguage: selectedLanguage,
    onSelectLanguage: onSelectLanguage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
    request: !indexHasMappings ? `${ingestCodeExamples.sense.updateMappingsCommand(codeParams)}\n\n${ingestCodeExamples.sense.ingestCommand(codeParams)}` : ingestCodeExamples.sense.ingestCommand(codeParams),
    application: application,
    sharePlugin: share,
    consolePlugin: consolePlugin
  }))), selectedCodeExamples.installCommand && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_code_sample.CodeSample, {
    id: "installCodeExample",
    title: ingestCodeExamples.installTitle,
    description: ingestCodeExamples.installDescription,
    language: "shell",
    code: selectedCodeExamples.installCommand,
    onCodeCopyClick: () => {
      usageTracker.click([_constants.AnalyticsEvents.indexDetailsInstallCodeCopy, `${_constants.AnalyticsEvents.indexDetailsInstallCodeCopy}_${selectedLanguage}`]);
    }
  })), !indexHasMappings && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_code_sample.CodeSample, {
    id: "addMappingsCodeExample",
    title: ingestCodeExamples.addMappingsTitle,
    description: ingestCodeExamples.addMappingsDescription,
    language: _code_examples.Languages[selectedLanguage].codeBlockLanguage,
    code: selectedCodeExamples.updateMappingsCommand(codeParams),
    onCodeCopyClick: () => {
      usageTracker.click([_constants.AnalyticsEvents.indexDetailsAddMappingsCodeCopy, `${_constants.AnalyticsEvents.indexDetailsAddMappingsCodeCopy}_${selectedLanguage}`]);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_code_sample.CodeSample, {
    id: "ingestDataCodeExample",
    title: _i18n.i18n.translate('xpack.searchIndices.indexDetails.ingestDocuments.title', {
      defaultMessage: 'Ingest documents'
    }),
    description: _i18n.i18n.translate('xpack.searchIndices.indexDetails.ingestDocuments.description', {
      defaultMessage: 'Next, use the Elasticsearch bulk API to ingest an array of documents into the index.'
    }),
    language: _code_examples.Languages[selectedLanguage].codeBlockLanguage,
    code: selectedCodeExamples.ingestCommand(codeParams),
    onCodeCopyClick: () => {
      usageTracker.click([_constants.AnalyticsEvents.indexDetailsIngestDocumentsCodeCopy, `${_constants.AnalyticsEvents.indexDetailsIngestDocumentsCodeCopy}_${selectedLanguage}`]);
    }
  }))));
};
exports.AddDocumentsCodeExample = AddDocumentsCodeExample;