"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportDeleteButton = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ReportDeleteButton extends _react.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      isDeleting: false,
      showConfirm: false
    };
  }
  hideConfirm() {
    this.setState({
      showConfirm: false
    });
  }
  showConfirm() {
    this.setState({
      showConfirm: true
    });
  }
  performDelete() {
    this.setState({
      isDeleting: true
    });
    this.props.performDelete().then(() => {
      this.setState({
        isDeleting: false
      });
    }).catch(err => {
      // eslint-disable-next-line no-console
      console.error(err);
      this.setState({
        isDeleting: false
      });
    });
  }
  renderConfirm() {
    const {
      jobsToDelete
    } = this.props;
    const title = jobsToDelete.length > 1 ? _i18n.i18n.translate('xpack.reporting.listing.table.deleteNumConfirmTitle', {
      defaultMessage: `Delete the {num} selected reports?`,
      values: {
        num: jobsToDelete.length
      }
    }) : _i18n.i18n.translate('xpack.reporting.listing.table.deleteConfirmTitle', {
      defaultMessage: `Delete the "{name}" report?`,
      values: {
        name: jobsToDelete[0].title
      }
    });
    const message = _i18n.i18n.translate('xpack.reporting.listing.table.deleteConfirmMessage', {
      defaultMessage: `You can't recover deleted reports.`
    });
    const confirmButtonText = _i18n.i18n.translate('xpack.reporting.listing.table.deleteConfirmButton', {
      defaultMessage: `Delete`
    });
    const cancelButtonText = _i18n.i18n.translate('xpack.reporting.listing.table.deleteCancelButton', {
      defaultMessage: `Cancel`
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: title,
      onCancel: () => this.hideConfirm(),
      onConfirm: () => this.performDelete(),
      confirmButtonText: confirmButtonText,
      confirmButtonDisabled: this.state.isDeleting,
      cancelButtonText: cancelButtonText,
      defaultFocusedButton: "confirm",
      buttonColor: "danger",
      "data-test-subj": "deleteReportConfirm"
    }, message);
  }
  render() {
    const {
      jobsToDelete
    } = this.props;
    if (jobsToDelete.length === 0) return null;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => this.showConfirm(),
      iconType: "trash",
      color: 'danger',
      "data-test-subj": "deleteReportButton",
      disabled: this.state.showConfirm
    }, _i18n.i18n.translate('xpack.reporting.listing.table.deleteReportButton', {
      defaultMessage: `Delete {num, plural, one {report} other {reports} }`,
      values: {
        num: jobsToDelete.length
      }
    })), this.state.showConfirm ? this.renderConfirm() : null);
  }
}
exports.ReportDeleteButton = ReportDeleteButton;