"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_query_params = require("./use_query_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVABILITY_TEXT = _i18n.i18n.translate('xpack.observabilityShared.breadcrumbs.observabilityLinkText', {
  defaultMessage: 'Observability'
});
function addClickHandlers(breadcrumbs, navigateToHref) {
  return breadcrumbs.map(bc => ({
    ...bc,
    ...(bc.href ? {
      onClick: event => {
        if (navigateToHref && bc.href) {
          event.preventDefault();
          navigateToHref(bc.href);
        }
      }
    } : {})
  }));
}
function getTitleFromBreadCrumbs(breadcrumbs) {
  return breadcrumbs.map(({
    text
  }) => {
    var _text$toString;
    return (_text$toString = text === null || text === void 0 ? void 0 : text.toString()) !== null && _text$toString !== void 0 ? _text$toString : '';
  }).reverse().concat([OBSERVABILITY_TEXT]);
}

/**
 *
 * By default the breadcrumbs will be passed to either serverless.setBreadcrumbs or chrome.setBreadcrumbs depending on the
 * environment. The breadcrumbs will *also* be passed to the project style breadcrumbs for stateful project style. We will use "project style"
 * here to refer to serverless chrome and stateful project style chrome. Classic refers to stateful classic chrome.
 *
 * Project style breadcrumbs add a root crumb ("deployment" etc) and "nav crumbs" which are derived from the navigation structure. By default
 * the "absolute" mode is used which means the breadcrumbs passed here will omit the navigation derived "nav crumbs". You can pass
 * absoluteProjectStyleBreadcrumbs: false to include the 'smart' "nav crumbs".
 *
 * In classic mode (not project style) the 'Observability' crumb is added.
 *
 * You can also pass classicOnly to only set breadrumbs in the classic chrome context. This can be useful if your solution just wants to defer all project style crumbs to the "nav crumbs".
 */
const useBreadcrumbs = (extraCrumbs, options) => {
  var _options$classicOnly, _getUrlForApp, _app$id;
  const params = (0, _use_query_params.useQueryParams)();
  const {
    app,
    breadcrumbsAppendExtension,
    serverless
  } = options !== null && options !== void 0 ? options : {};
  const absolute = (options === null || options === void 0 ? void 0 : options.absoluteProjectStyleBreadcrumbs) === false ? false : true;
  const classicOnly = (_options$classicOnly = options === null || options === void 0 ? void 0 : options.classicOnly) !== null && _options$classicOnly !== void 0 ? _options$classicOnly : false;
  const {
    services: {
      chrome: {
        docTitle,
        setBreadcrumbs: chromeSetBreadcrumbs,
        setBreadcrumbsAppendExtension,
        getChromeStyle$
      },
      application: {
        getUrlForApp,
        navigateToUrl
      }
    }
  } = (0, _public.useKibana)();
  const setTitle = docTitle.change;
  const appPath = (_getUrlForApp = getUrlForApp((_app$id = app === null || app === void 0 ? void 0 : app.id) !== null && _app$id !== void 0 ? _app$id : 'observability-overview')) !== null && _getUrlForApp !== void 0 ? _getUrlForApp : '';
  const chromeStyle = (0, _useObservable.default)(getChromeStyle$());
  const setBreadcrumbs = (0, _react.useMemo)(() => {
    if (!(serverless !== null && serverless !== void 0 && serverless.setBreadcrumbs)) {
      return breadcrumbs => chromeSetBreadcrumbs === null || chromeSetBreadcrumbs === void 0 ? void 0 : chromeSetBreadcrumbs(breadcrumbs, !classicOnly ? {
        project: {
          value: breadcrumbs,
          absolute
        }
      } : undefined);
    }
    if (!classicOnly) return breadcrumbs => serverless === null || serverless === void 0 ? void 0 : serverless.setBreadcrumbs(breadcrumbs, {
      absolute
    });
  }, [serverless, classicOnly, absolute, chromeSetBreadcrumbs]);
  (0, _react.useEffect)(() => {
    if (breadcrumbsAppendExtension) {
      setBreadcrumbsAppendExtension(breadcrumbsAppendExtension);
    }
    return () => {
      if (breadcrumbsAppendExtension) {
        setBreadcrumbsAppendExtension(undefined);
      }
    };
  }, [breadcrumbsAppendExtension, setBreadcrumbsAppendExtension]);
  (0, _react.useEffect)(() => {
    var _app$label;
    const isProjectStyle = serverless || chromeStyle === 'project';
    const breadcrumbs = isProjectStyle ? extraCrumbs : [{
      text: (_app$label = app === null || app === void 0 ? void 0 : app.label) !== null && _app$label !== void 0 ? _app$label : OBSERVABILITY_TEXT,
      href: appPath + '/overview'
    }, ...extraCrumbs];
    if (setBreadcrumbs) {
      setBreadcrumbs(addClickHandlers(breadcrumbs, navigateToUrl));
    }
    if (setTitle) {
      setTitle(getTitleFromBreadCrumbs(extraCrumbs));
    }
  }, [app === null || app === void 0 ? void 0 : app.label, appPath, chromeStyle, extraCrumbs, navigateToUrl, params, serverless, setBreadcrumbs, setTitle]);
};
exports.useBreadcrumbs = useBreadcrumbs;