"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HAS_DATA_FETCH_INTERVAL = void 0;
exports.buildCreateStackAWSConsoleURL = buildCreateStackAWSConsoleURL;
exports.buildCreateStackCommand = buildCreateStackCommand;
exports.buildStackStatusCommand = buildStackStatusCommand;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HAS_DATA_FETCH_INTERVAL = exports.HAS_DATA_FETCH_INTERVAL = 5000;
function buildCreateStackCommand({
  templateUrl,
  stackName,
  streamName,
  encodedApiKey,
  elasticsearchUrl
}) {
  const escapedElasticsearchUrl = elasticsearchUrl.replace(/\//g, '\\/');
  const escapedTemplateUrl = templateUrl.replace(/\//g, '\\/');
  return `
    aws cloudformation create-stack
      --stack-name ${stackName}
      --template-url ${escapedTemplateUrl}
      --parameters ParameterKey=FirehoseStreamName,ParameterValue=${streamName}
                   ParameterKey=ElasticEndpointURL,ParameterValue=${escapedElasticsearchUrl}
                   ParameterKey=ElasticAPIKey,ParameterValue=${encodedApiKey}
      --capabilities CAPABILITY_IAM
  `.trim().replace(/\n/g, ' ').replace(/\s\s+/g, ' ');
}
function buildStackStatusCommand({
  stackName
}) {
  return `
    aws cloudformation describe-stacks
      --stack-name ${stackName}
      --query "Stacks[0].StackStatus"
  `.trim().replace(/\n/g, ' ').replace(/\s\s+/g, ' ');
}
function buildCreateStackAWSConsoleURL({
  templateUrl,
  stackName,
  streamName,
  elasticsearchUrl,
  encodedApiKey
}) {
  const url = new URL('https://console.aws.amazon.com');
  const params = new URLSearchParams({
    templateURL: templateUrl,
    stackName,
    /**
     * 'param_' format is enforced by AWS
     * but template parameters are in CamelCase
     * which triggers the eslint rule.
     */
    /* eslint-disable @typescript-eslint/naming-convention */
    param_FirehoseStreamName: streamName,
    param_ElasticEndpointURL: elasticsearchUrl,
    param_ElasticAPIKey: encodedApiKey
    /* eslint-enable @typescript-eslint/naming-convention */
  });
  url.pathname = '/cloudformation/home';
  url.hash = `/stacks/quickcreate?${params.toString()}`;
  return url.toString();
}