"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityLink = exports.ConnectedDatasetQualityLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _routerUtils = require("@kbn/router-utils");
var _react = require("@xstate/react");
var _react2 = _interopRequireDefault(require("react"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _translations = require("../../common/translations");
var _src = require("../state_machines/observability_logs_explorer/src");
var _use_kibana = require("../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectedDatasetQualityLink = () => {
  const {
    services: {
      share: {
        url
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [pageState] = (0, _react.useActor)((0, _src.useObservabilityLogsExplorerPageStateContext)());
  const locator = url.locators.get(_deeplinksObservability.DATA_QUALITY_LOCATOR_ID);
  if (!locator) {
    return null;
  }
  return /*#__PURE__*/_react2.default.createElement(DatasetQualityLink, {
    locator: locator,
    pageState: pageState.matches({
      initialized: 'validLogsExplorerState'
    }) ? pageState : undefined
  });
};
exports.ConnectedDatasetQualityLink = ConnectedDatasetQualityLink;
const constructLocatorParams = logsExplorerState => {
  const {
    time,
    refreshInterval
  } = logsExplorerState;
  const locatorParams = {
    filters: {
      timeRange: {
        from: (time === null || time === void 0 ? void 0 : time.from) || 'now-24h',
        to: (time === null || time === void 0 ? void 0 : time.to) || 'now',
        refresh: {
          pause: refreshInterval ? refreshInterval.pause : false,
          value: refreshInterval ? refreshInterval.value : 60000
        }
      }
    }
  };
  return locatorParams;
};
const DatasetQualityLink = exports.DatasetQualityLink = /*#__PURE__*/_react2.default.memo(({
  locator,
  pageState
}) => {
  const locatorParams = pageState ? constructLocatorParams(pageState.context.logsExplorerState) : {};
  const datasetQualityUrl = locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl(locatorParams);
  const navigateToDatasetQuality = () => {
    locator === null || locator === void 0 ? void 0 : locator.navigate(locatorParams);
  };
  const datasetQualityLinkProps = (0, _routerUtils.getRouterLinkProps)({
    href: datasetQualityUrl,
    onClick: navigateToDatasetQuality
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderLink, (0, _extends2.default)({}, datasetQualityLinkProps, {
    color: "primary",
    "data-test-subj": "logsExplorerDatasetQualityLink"
  }), _translations.datasetQualityLinkTitle);
});