"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partitionFieldValuesSchema = exports.maxAnomalyScoreSchema = exports.getDatafeedResultsChartDataSchema = exports.getCategorizerStoppedPartitionsSchema = exports.getCategorizerStatsSchema = exports.getAnomalyRecordsSchema = exports.getAnomalyChartsSchema = exports.categoryExamplesSchema = exports.categoryDefinitionSchema = exports.anomalySearchSchema = exports.anomaliesTableDataSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const criteriaFieldSchema = _configSchema.schema.object({
  fieldType: _configSchema.schema.maybe(_configSchema.schema.string()),
  fieldName: _configSchema.schema.string(),
  fieldValue: _configSchema.schema.any()
});
const anomaliesTableDataSchema = exports.anomaliesTableDataSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  criteriaFields: _configSchema.schema.arrayOf(criteriaFieldSchema),
  influencers: _configSchema.schema.arrayOf(_configSchema.schema.maybe(_configSchema.schema.object({
    fieldName: _configSchema.schema.string(),
    fieldValue: _configSchema.schema.any()
  }))),
  aggregationInterval: _configSchema.schema.string(),
  threshold: _configSchema.schema.number(),
  earliestMs: _configSchema.schema.number(),
  latestMs: _configSchema.schema.number(),
  dateFormatTz: _configSchema.schema.string(),
  maxRecords: _configSchema.schema.number(),
  maxExamples: _configSchema.schema.maybe(_configSchema.schema.number()),
  influencersFilterQuery: _configSchema.schema.maybe(_configSchema.schema.any()),
  functionDescription: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string()))
});
const categoryDefinitionSchema = exports.categoryDefinitionSchema = _configSchema.schema.object({
  jobId: _configSchema.schema.maybe(_configSchema.schema.string()),
  categoryId: _configSchema.schema.string()
});
const maxAnomalyScoreSchema = exports.maxAnomalyScoreSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  earliestMs: _configSchema.schema.maybe(_configSchema.schema.number()),
  latestMs: _configSchema.schema.maybe(_configSchema.schema.number())
});
const categoryExamplesSchema = exports.categoryExamplesSchema = _configSchema.schema.object({
  jobId: _configSchema.schema.string(),
  categoryIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  maxExamples: _configSchema.schema.number()
});
const anomalySearchSchema = exports.anomalySearchSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  query: _configSchema.schema.any()
});
const fieldConfig = _configSchema.schema.maybe(_configSchema.schema.object({
  applyTimeRange: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  anomalousOnly: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  sort: _configSchema.schema.object({
    by: _configSchema.schema.string(),
    order: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  value: _configSchema.schema.maybe(_configSchema.schema.string())
}));
const partitionFieldValuesSchema = exports.partitionFieldValuesSchema = _configSchema.schema.object({
  jobId: _configSchema.schema.string(),
  searchTerm: _configSchema.schema.maybe(_configSchema.schema.any()),
  criteriaFields: _configSchema.schema.arrayOf(criteriaFieldSchema),
  earliestMs: _configSchema.schema.number(),
  latestMs: _configSchema.schema.number(),
  fieldsConfig: _configSchema.schema.maybe(_configSchema.schema.object({
    partition_field: fieldConfig,
    over_field: fieldConfig,
    by_field: fieldConfig
  }))
});
const getCategorizerStatsSchema = exports.getCategorizerStatsSchema = _configSchema.schema.object({
  partitionByValue: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Optional value to fetch the categorizer stats where results are filtered by partition_by_value = value'
    }
  }))
});
const getCategorizerStoppedPartitionsSchema = exports.getCategorizerStoppedPartitionsSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    meta: {
      description: 'List of jobIds to fetch the categorizer partitions for'
    }
  }),
  fieldToBucket: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: `Field to aggregate results by: 'job_id' or 'partition_field_value'. If by job_id, will return list of jobIds with at least one partition that have stopped. If by partition_field_value, it will return a list of categorizer stopped partitions for each job_id`
    }
  }))
});
const getDatafeedResultsChartDataSchema = exports.getDatafeedResultsChartDataSchema = _configSchema.schema.object({
  jobId: _configSchema.schema.string({
    meta: {
      description: 'Job id to fetch the bucket results for'
    }
  }),
  start: _configSchema.schema.number(),
  end: _configSchema.schema.number()
});
const getAnomalyChartsSchema = exports.getAnomalyChartsSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  influencers: _configSchema.schema.arrayOf(_configSchema.schema.any()),
  threshold: _configSchema.schema.number({
    defaultValue: 0,
    min: 0,
    max: 99,
    meta: {
      description: 'Severity threshold'
    }
  }),
  earliestMs: _configSchema.schema.number(),
  latestMs: _configSchema.schema.number(),
  maxResults: _configSchema.schema.number({
    defaultValue: 6,
    min: 1,
    max: 50,
    meta: {
      description: 'Maximum amount of series data'
    }
  }),
  influencersFilterQuery: _configSchema.schema.maybe(_configSchema.schema.any()),
  numberOfPoints: _configSchema.schema.number({
    meta: {
      description: 'Optimal number of data points per chart'
    }
  }),
  timeBounds: _configSchema.schema.object({
    min: _configSchema.schema.maybe(_configSchema.schema.number()),
    max: _configSchema.schema.maybe(_configSchema.schema.number())
  })
});
const getAnomalyRecordsSchema = exports.getAnomalyRecordsSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  threshold: _configSchema.schema.number({
    defaultValue: 0,
    min: 0,
    max: 99
  }),
  earliestMs: _configSchema.schema.number(),
  latestMs: _configSchema.schema.number(),
  criteriaFields: _configSchema.schema.arrayOf(_configSchema.schema.any()),
  interval: _configSchema.schema.string(),
  functionDescription: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string()))
});