"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CannotImportJobsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CannotImportJobsCallout = ({
  jobs,
  autoExpand = false
}) => {
  if (jobs.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.importExport.importFlyout.cannotImportJobCallout.title', {
      defaultMessage: '{num, plural, one {# job} other {# jobs}} cannot be imported',
      values: {
        num: jobs.length
      }
    }),
    color: "warning",
    "data-test-subj": "mlJobMgmtImportJobsCannotBeImportedCallout"
  }, autoExpand ? /*#__PURE__*/_react.default.createElement(SkippedJobList, {
    jobs: jobs
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedOptions",
    paddingSize: "s",
    "aria-label": _i18n.i18n.translate('xpack.ml.importExport.importFlyout.cannotImportJobCallout.jobListAria', {
      defaultMessage: 'view jobs'
    }),
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.importExport.importFlyout.cannotImportJobCallout.jobListButton",
      defaultMessage: "View jobs"
    })
  }, /*#__PURE__*/_react.default.createElement(SkippedJobList, {
    jobs: jobs
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.CannotImportJobsCallout = CannotImportJobsCallout;
const SkippedJobList = ({
  jobs
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobs.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobs.map(({
  jobId,
  missingFilters,
  sourceIndicesErrors
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  key: jobId
}, /*#__PURE__*/_react.default.createElement("h5", null, jobId), missingFilters && missingFilters.length > 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.importExport.importFlyout.cannotImportJobCallout.missingFilters",
  defaultMessage: "Missing filter {num, plural, one {list} other {lists}}: {filters}",
  values: {
    num: missingFilters.length,
    filters: missingFilters.join(',')
  }
}), sourceIndicesErrors && sourceIndicesErrors.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, sourceIndicesErrors.map(({
  index,
  error
}, i) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  key: `${jobId}-${index !== null && index !== void 0 ? index : 'undefined'}-${error}`,
  id: "xpack.ml.importExport.importFlyout.cannotImportJobCallout.sourceIndexValidationFailed",
  defaultMessage: "{index, select, undefined {Source indices validation failed} other {Source index validation failed for {index}}}{reason, select, undefined {} other { Reason: {reason}}}{br}",
  values: {
    index,
    reason: error,
    br: i < sourceIndicesErrors.length - 1 ? /*#__PURE__*/_react.default.createElement("br", null) : ''
  }
})))))));