"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * uiSettings definitions for Logs Explorer.
 */
const uiSettings = exports.uiSettings = {
  [_managementSettingsIds.OBSERVABILITY_LOGS_EXPLORER_ALLOWED_DATA_VIEWS_ID]: {
    category: ['observability'],
    name: _i18n.i18n.translate('xpack.logsExplorer.allowedDataViews', {
      defaultMessage: 'Logs Explorer allowed data views'
    }),
    value: _discoverUtils.DEFAULT_ALLOWED_LOGS_BASE_PATTERNS,
    description: _i18n.i18n.translate('xpack.logsExplorer.allowedDataViewsDescription', {
      defaultMessage: 'A list of base patterns to match and explore data views in Logs Explorer. Remote clusters will be automatically matched for the provided base patterns.'
    }),
    deprecation: {
      message: _i18n.i18n.translate('xpack.logsExplorer.allowedDataViewsDeprecationWarning', {
        defaultMessage: 'Logs Explorer is deprecated, and this setting will be removed in Kibana 9.0.'
      }),
      docLinksKey: 'generalSettings'
    },
    type: 'array',
    schema: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    requiresPageReload: true
  }
};