"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIntegration = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _telemetry = require("./telemetry");
var _create_integration_landing = require("./create_integration_landing");
var _create_integration_upload = require("./create_integration_upload");
var _create_integration_assistant = require("./create_integration_assistant");
var _constants = require("../../common/constants");
var _use_authorization = require("../../common/hooks/use_authorization");
var _use_availability = require("../../common/hooks/use_availability");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateIntegration = exports.CreateIntegration = /*#__PURE__*/_react.default.memo(({
  services
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_telemetry.TelemetryContextProvider, null, /*#__PURE__*/_react.default.createElement(CreateIntegrationRouter, null))));
CreateIntegration.displayName = 'CreateIntegration';
const CreateIntegrationRouter = /*#__PURE__*/_react.default.memo(() => {
  const {
    canUseIntegrationAssistant,
    canUseIntegrationUpload
  } = (0, _use_authorization.useRoutesAuthorization)();
  const isAvailable = (0, _use_availability.useIsAvailable)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, isAvailable && canUseIntegrationAssistant && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.PagePath[_constants.Page.assistant],
    exact: true,
    component: _create_integration_assistant.CreateIntegrationAssistant
  }), isAvailable && canUseIntegrationUpload && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.PagePath[_constants.Page.upload],
    exact: true,
    component: _create_integration_upload.CreateIntegrationUpload
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.PagePath[_constants.Page.landing],
    exact: true,
    component: _create_integration_landing.CreateIntegrationLanding
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.PagePath[_constants.Page.landing]
    })
  }));
});
CreateIntegrationRouter.displayName = 'CreateIntegrationRouter';