"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRuleDataClient = void 0;
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _server = require("@kbn/rule-registry-plugin/server");
var _common = require("@kbn/alerting-plugin/common");
var _server2 = require("@kbn/alerting-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRuleDataClient = ({
  ownerFeatureId,
  registrationContext,
  getStartServices,
  logger,
  ruleDataService
}) => {
  return ruleDataService.initializeIndex({
    feature: ownerFeatureId,
    registrationContext,
    dataset: _server.Dataset.alerts,
    componentTemplateRefs: [_server2.ECS_COMPONENT_TEMPLATE_NAME],
    componentTemplates: [{
      name: 'mappings',
      mappings: (0, _common.mappingFromFieldMap)(_alertsAsDataUtils.legacyExperimentalFieldMap, 'strict')
    }]
  });
};
exports.createRuleDataClient = createRuleDataClient;