"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaAdvancedSettingConfigurationPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/logs-data-access-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KibanaAdvancedSettingConfigurationPanel = () => {
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _public.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_source_configuration_kibana_advanced_setting'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_source_configuration_kibana_advanced_setting',
    delay: 15000
  });
  const {
    isLoadingLogSources,
    combinedIndices
  } = (0, _public2.useLogSourcesContext)();
  return /*#__PURE__*/_react.default.createElement(_public2.LogSourcesSettingSynchronisationInfo, {
    isLoading: isLoadingLogSources,
    logSourcesValue: combinedIndices,
    getUrlForApp: application.getUrlForApp
  });
};
exports.KibanaAdvancedSettingConfigurationPanel = KibanaAdvancedSettingConfigurationPanel;