"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogViewConfigurationContext = exports.useLogViewConfiguration = exports.availableTextScales = exports.LogViewConfigurationProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogViewConfiguration = () => {
  // text scale
  const [textScale, setTextScale] = (0, _react.useState)('medium');

  // text wrap
  const [textWrap, setTextWrap] = (0, _react.useState)(true);
  return {
    availableTextScales,
    setTextScale,
    setTextWrap,
    textScale,
    textWrap
  };
};
exports.useLogViewConfiguration = useLogViewConfiguration;
const [LogViewConfigurationProvider, useLogViewConfigurationContext] = (0, _constate.default)(useLogViewConfiguration);

/**
 * constants
 */
exports.useLogViewConfigurationContext = useLogViewConfigurationContext;
exports.LogViewConfigurationProvider = LogViewConfigurationProvider;
const availableTextScales = exports.availableTextScales = ['large', 'medium', 'small'];