"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogDatepicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogDatepicker = ({
  startDateExpression,
  endDateExpression,
  isStreaming,
  onUpdateDateRange,
  onStartStreaming,
  onStopStreaming
}) => {
  const handleTimeChange = (0, _react.useCallback)(({
    start,
    end,
    isInvalid
  }) => {
    if (onUpdateDateRange && !isInvalid) {
      onUpdateDateRange({
        startDateExpression: start,
        endDateExpression: end
      });
    }
  }, [onUpdateDateRange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: startDateExpression,
    end: endDateExpression,
    onTimeChange: handleTimeChange,
    showUpdateButton: false
    // @ts-ignore: EuiSuperDatePicker doesn't expose the `isDisabled` prop, although it exists.
    ,
    isDisabled: isStreaming
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isStreaming ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraLogDatepickerStopStreamingButton",
    color: "primary",
    iconType: "pause",
    iconSide: "left",
    onClick: onStopStreaming
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.stopStreamingButtonLabel",
    defaultMessage: "Stop streaming"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraLogDatepickerStreamLiveButton",
    color: "primary",
    iconType: "play",
    iconSide: "left",
    onClick: onStartStreaming
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.startStreamingButtonLabel",
    defaultMessage: "Stream live"
  }))));
};
exports.LogDatepicker = LogDatepicker;