"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultipleMappingsWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../../services/documentation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MultipleMappingsWarning = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.mappingTypesDetectedCallOutTitle', {
    defaultMessage: 'Mapping types detected'
  }),
  iconType: "warning",
  color: "warning",
  "data-test-subj": "mappingTypesDetectedCallout"
}, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.idxMgmt.mappingsEditor.mappingTypesDetectedCallOutDescription",
  defaultMessage: "The mappings for this template uses types, which have been removed. {docsLink}",
  values: {
    docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _documentation.documentationService.getAlternativeToMappingTypesLink(),
      target: "_blank"
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.mappingTypesDetectedCallOutDocumentationLink', {
      defaultMessage: 'Consider these alternatives to mapping types.'
    }))
  }
})));
exports.MultipleMappingsWarning = MultipleMappingsWarning;