"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureCatalogueRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @public */

/** @public */

/** @public */

class FeatureCatalogueRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "capabilities", null);
    (0, _defineProperty2.default)(this, "solutions", new Map());
    (0, _defineProperty2.default)(this, "featuresSubject", new _rxjs.BehaviorSubject(new Map()));
  }
  setup() {
    return {
      register: feature => {
        const {
          value: features
        } = this.featuresSubject;
        if (features.has(feature.id)) {
          throw new Error(`Feature with id [${feature.id}] has already been registered. Use a unique id.`);
        }
        features.set(feature.id, feature);
        this.featuresSubject.next(new Map(features));
      },
      registerSolution: solution => {
        if (this.solutions.has(solution.id)) {
          throw new Error(`Solution with id [${solution.id}] has already been registered. Use a unique id.`);
        }
        this.solutions.set(solution.id, solution);
      }
    };
  }
  start({
    capabilities
  }) {
    this.capabilities = capabilities;
  }

  /**
   * @deprecated
   * Use getFeatures$() instead
   */
  get(features = this.featuresSubject.value) {
    if (this.capabilities === null) {
      throw new Error('Catalogue entries are only available after start phase');
    }
    const capabilities = this.capabilities;
    return [...features.values()].filter(entry => capabilities.catalogue[entry.id] !== false && (entry.visible ? entry.visible() : true)).sort(compareByKey('title'));
  }
  getFeatures$() {
    return this.featuresSubject.pipe((0, _rxjs.map)(feats => this.get(feats)));
  }
  getSolutions() {
    if (this.capabilities === null) {
      throw new Error('Catalogue entries are only available after start phase');
    }
    const capabilities = this.capabilities;
    return [...this.solutions.values()].filter(solution => {
      var _solution$isVisible, _solution$isVisible2;
      return (_solution$isVisible = (_solution$isVisible2 = solution.isVisible) === null || _solution$isVisible2 === void 0 ? void 0 : _solution$isVisible2.call(solution, capabilities)) !== null && _solution$isVisible !== void 0 ? _solution$isVisible : capabilities.catalogue[solution.id] !== false;
    }).sort(compareByKey('title'));
  }
  removeFeature(appId) {
    const {
      value: features
    } = this.featuresSubject;
    features.delete(appId);
    this.featuresSubject.next(new Map(features));
  }
}
exports.FeatureCatalogueRegistry = FeatureCatalogueRegistry;
const compareByKey = key => (left, right) => {
  if (left[key] < right[key]) {
    return -1;
  } else if (left[key] > right[key]) {
    return 1;
  } else {
    return 0;
  }
};