"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.compileFnName = void 0;
var _handlebars = require("./src/handlebars");
var _utils = require("./src/utils");
/*
 * Elasticsearch B.V licenses this file to you under the MIT License.
 * See `src/platform/packages/private/kbn-handlebars/LICENSE` for more information.
 */
// The handlebars module uses `export =`, so it can't be re-exported using `export *`.
// However, because of Babel, we're not allowed to use `export =` ourselves.
// So we have to resort to using `exports default` even though eslint doesn't like it.
//
// eslint-disable-next-line import/no-default-export
var _default = exports.default = _handlebars.Handlebars;
/**
 * If the `unsafe-eval` CSP is set, this string constant will be `compile`,
 * otherwise `compileAST`.
 *
 * This can be used to call the more optimized `compile` function in
 * environments that support it, or fall back to `compileAST` on environments
 * that don't.
 */
const compileFnName = exports.compileFnName = (0, _utils.allowUnsafeEval)() ? 'compile' : 'compileAST';