"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadMappingForTransform = loadMappingForTransform;
var _field = require("../../fields/field");
var _template = require("../template/template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function loadMappingForTransform(packageInstallContext, transformModuleId) {
  const fields = (0, _field.loadTransformFieldsFromYaml)(packageInstallContext, transformModuleId);
  const validFields = (0, _field.processFields)(fields);
  return (0, _template.generateMappings)(validFields);
}