"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalConnectorFormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _external_connector_logic = require("./external_connector_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExternalConnectorFormFields = () => {
  const {
    urlValid,
    externalConnectorApiKey,
    externalConnectorUrl,
    formDisabled,
    showInsecureUrlCallout
  } = (0, _kea.useValues)(_external_connector_logic.ExternalConnectorLogic);
  const {
    fetchExternalSource,
    validateUrl,
    setExternalConnectorApiKey,
    setExternalConnectorUrl
  } = (0, _kea.useActions)(_external_connector_logic.ExternalConnectorLogic);
  (0, _react.useEffect)(() => {
    fetchExternalSource();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showInsecureUrlCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.insecureTitle', {
      defaultMessage: 'Connection not secure'
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.insecureWarning', {
    defaultMessage: 'Your connector is using an HTTP connection, which is not private. Information synced by this connector could be viewed by others. Connect over HTTPS to secure your information.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.urlLabel', {
      defaultMessage: 'Connector URL'
    }),
    isInvalid: !urlValid,
    helpText: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.helpText', {
      defaultMessage: 'URLs should start with https://'
    }),
    error: urlValid ? [] : [_i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.error', {
      defaultMessage: 'Please use a valid URL'
    })]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: externalConnectorUrl,
    disabled: formDisabled,
    onBlur: validateUrl,
    required: true,
    type: "text",
    autoComplete: "off",
    onChange: e => setExternalConnectorUrl(e.target.value),
    name: "external-connector-url"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.apiKeyLabel', {
      defaultMessage: 'Connector API key'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: externalConnectorApiKey,
    disabled: formDisabled,
    required: true,
    type: "text",
    autoComplete: "off",
    onChange: e => setExternalConnectorApiKey(e.target.value),
    name: "external-connector-api-key"
  })));
};
exports.ExternalConnectorFormFields = ExternalConnectorFormFields;