"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchLabsBanner = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _http = require("../http");
var _search_labs_logo = require("./search_labs_logo");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchLabsBanner = () => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const backgroundImagePath = http.basePath.prepend('/plugins/enterpriseSearch/assets/images/search_labs_banner_background.svg');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: true,
    color: "success",
    css: (0, _react2.css)`
        background-image: url(${backgroundImagePath});
        background-repeat: no-repeat;
      `
  }, /*#__PURE__*/_react.default.createElement(_search_labs_logo.SearchLabsLogo, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.shared.searchLabsBanner.logoAltLabel', {
      defaultMessage: 'Elastic Search Labs'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.shared.searchLabsBanner.searchLabsTitle', {
    defaultMessage: 'Get started with vector search and ML'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.shared.searchLabsBanner.searchLabsDescription', {
    defaultMessage: 'Elastic Search Labs contains a range of technical content for building search experiences powered by Elasticsearch’s vector search capabilities and generative AI.  Dive straight into the code with our sample apps and executable Python notebooks.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: "https://www.elastic.co/search-labs/tutorials",
    color: "success",
    fill: true,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.shared.searchLabsBanner.tutorialsLabel', {
    defaultMessage: 'Tutorials'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: "https://www.elastic.co/search-labs/tutorials/examples",
    color: "success",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.shared.searchLabsBanner.notebooksLabel', {
    defaultMessage: 'Notebooks & Examples'
  }))))));
};
exports.SearchLabsBanner = SearchLabsBanner;