"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.domainConfigsToDomainUrls = exports.domainConfigsToDomainConfigMap = exports.CrawlCustomSettingsFlyoutDomainConfigLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../../../shared/flash_messages");
var _http = require("../../../../../shared/http");
var _utils = require("../../../../api/crawler/utils");
var _index_name_logic = require("../../index_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const domainConfigsToDomainUrls = domainConfigs => domainConfigs.map(domainConfig => domainConfig.name);
exports.domainConfigsToDomainUrls = domainConfigsToDomainUrls;
const domainConfigsToDomainConfigMap = domainConfigs => domainConfigs.reduce((acc, domainConfig) => ({
  ...acc,
  [domainConfig.name]: domainConfig
}), {});
exports.domainConfigsToDomainConfigMap = domainConfigsToDomainConfigMap;
const CrawlCustomSettingsFlyoutDomainConfigLogic = exports.CrawlCustomSettingsFlyoutDomainConfigLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'crawler', 'crawl_custom_settings_flyout_domain_logic'],
  actions: () => ({
    fetchDomainConfigData: true,
    onRecieveDomainConfigData: domainConfigs => ({
      domainConfigs
    })
  }),
  reducers: () => ({
    domainConfigs: [[], {
      onRecieveDomainConfigData: (_, {
        domainConfigs
      }) => domainConfigs
    }]
  }),
  selectors: () => ({
    domainUrls: [selectors => [selectors.domainConfigs], domainConfigs => domainConfigsToDomainUrls(domainConfigs)],
    domainConfigMap: [selectors => [selectors.domainConfigs], domainConfigs => domainConfigsToDomainConfigMap(domainConfigs)]
  }),
  listeners: ({
    actions
  }) => ({
    fetchDomainConfigData: async () => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        indexName
      } = _index_name_logic.IndexNameLogic.values;
      let domainConfigs = [];
      let totalPages = 1;
      let nextPage = 1;
      let pageSize = 100;
      try {
        while (nextPage <= totalPages) {
          const {
            results,
            meta: {
              page
            }
          } = await http.get(`/internal/enterprise_search/indices/${indexName}/crawler/domain_configs`, {
            query: {
              'page[current]': nextPage,
              'page[size]': pageSize
            }
          });
          domainConfigs = [...domainConfigs, ...results.map(_utils.domainConfigServerToClient)];
          nextPage = page.current + 1;
          totalPages = page.total_pages;
          pageSize = page.size;
        }
        actions.onRecieveDomainConfigData(domainConfigs);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});