"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAppSearchNav = exports.cleanAppSearchNavItems = void 0;
var _kea = require("kea");
var _layout = require("../../../shared/layout");
var _constants = require("../../../shared/role_mapping/constants");
var _app_logic = require("../../app_logic");
var _routes = require("../../routes");
var _credentials = require("../credentials");
var _engine_nav = require("../engine/engine_nav");
var _engines = require("../engines");
var _settings = require("../settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAppSearchNav = () => {
  const {
    myRole: {
      canViewSettings,
      canViewAccountCredentials,
      canViewRoleMappings
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const navItems = [{
    id: 'engines',
    name: _engines.ENGINES_TITLE,
    ...(0, _layout.generateNavLink)({
      to: _routes.ENGINES_PATH,
      shouldShowActiveForSubroutes: true,
      items: (0, _engine_nav.useEngineNav)()
    })
  }];
  if (canViewSettings) {
    navItems.push({
      id: 'settings',
      name: _settings.SETTINGS_TITLE,
      ...(0, _layout.generateNavLink)({
        to: _routes.SETTINGS_PATH
      })
    });
  }
  if (canViewAccountCredentials) {
    navItems.push({
      id: 'credentials',
      name: _credentials.CREDENTIALS_TITLE,
      ...(0, _layout.generateNavLink)({
        to: _routes.CREDENTIALS_PATH
      })
    });
  }
  if (canViewRoleMappings) {
    navItems.push({
      id: 'usersRoles',
      name: _constants.ROLE_MAPPINGS_TITLE,
      ...(0, _layout.generateNavLink)({
        to: _routes.USERS_AND_ROLES_PATH
      })
    });
  }

  // Root level items are meant to be section headers, but the AS nav (currently)
  // isn't organized this way. So we create a fake empty parent item here
  // to cause all our navItems to properly render as nav links.
  return [{
    id: '',
    name: '',
    items: navItems
  }];
};

// Process App Search side nav items for use in the new Solution Nav
exports.useAppSearchNav = useAppSearchNav;
const cleanAppSearchNavItems = items => {
  const enginesItem = items.find(item => item.id === 'engines');
  if (enginesItem && enginesItem.items && enginesItem.items.length > 0) {
    const engineChildren = enginesItem.items;
    const engineNameItem = engineChildren.find(item => item.id === 'engineName');
    if (engineNameItem && engineNameItem.renderItem) {
      delete engineNameItem.renderItem;
      engineNameItem.items = engineChildren.filter(item => item.id !== 'engineName');
      enginesItem.items = [engineNameItem];
    }
  }
  return items;
};
exports.cleanAppSearchNavItems = cleanAppSearchNavItems;