"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PagingView = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PagingView = ({
  current = 1,
  onChange,
  totalPages,
  'aria-label': ariaLabel
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
  pageCount: totalPages,
  activePage: current - 1 // EuiPagination is 0-indexed, Search UI is 1-indexed
  ,
  onPageClick: page => onChange(page + 1) // EuiPagination is 0-indexed, Search UI is 1-indexed
  ,
  "aria-label": ariaLabel
});
exports.PagingView = PagingView;