"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Query = exports.IntervalSchedule = exports.Filters = exports.AttackDiscoveryScheduleUpdateProps = exports.AttackDiscoveryScheduleParams = exports.AttackDiscoveryScheduleExecutionStatusEnum = exports.AttackDiscoveryScheduleExecutionStatus = exports.AttackDiscoveryScheduleExecution = exports.AttackDiscoveryScheduleCreateProps = exports.AttackDiscoveryScheduleActionThrottle = exports.AttackDiscoveryScheduleActionParams = exports.AttackDiscoveryScheduleActionNotifyWhenEnum = exports.AttackDiscoveryScheduleActionNotifyWhen = exports.AttackDiscoveryScheduleActionId = exports.AttackDiscoveryScheduleActionGroup = exports.AttackDiscoveryScheduleActionFrequency = exports.AttackDiscoveryScheduleActionAlertsFilter = exports.AttackDiscoveryScheduleAction = exports.AttackDiscoverySchedule = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../conversations/common_attributes.gen");
var _common_attributes2 = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Attack Discovery Schedule Types
 *   version: not applicable
 */

/**
 * An query condition to filter alerts
 */

const Query = exports.Query = _zod.z.object({
  query: _zod.z.union([_zod.z.string(), _zod.z.object({}).catchall(_zod.z.unknown())]),
  language: _zod.z.string()
});

/**
 * The filter array used to define the conditions for when alerts are selected as an attack discovery context. Defaults to an empty array.
 */

const Filters = exports.Filters = _zod.z.array(_zod.z.unknown());

/**
 * An attack discovery schedule params
 */

const AttackDiscoveryScheduleParams = exports.AttackDiscoveryScheduleParams = _zod.z.object({
  /**
   * The index pattern to get alerts from
   */
  alertsIndexPattern: _zod.z.string(),
  /**
   * LLM API configuration.
   */
  apiConfig: _common_attributes.ApiConfig.merge(_zod.z.object({
    /**
     * The name of the connector
     */
    name: _zod.z.string()
  })),
  end: _zod.z.string().optional(),
  query: Query.optional(),
  filters: Filters.optional(),
  combinedFilter: _zod.z.object({}).catchall(_zod.z.unknown()).optional(),
  size: _zod.z.number(),
  start: _zod.z.string().optional()
});
const IntervalSchedule = exports.IntervalSchedule = _zod.z.object({
  /**
   * The schedule interval
   */
  interval: _zod.z.string()
});

/**
 * Groups actions by use cases. Use `default` for alert notifications.
 */

const AttackDiscoveryScheduleActionGroup = exports.AttackDiscoveryScheduleActionGroup = _zod.z.string();

/**
 * The connector ID.
 */

const AttackDiscoveryScheduleActionId = exports.AttackDiscoveryScheduleActionId = _zod.z.string();

/**
 * Object containing the allowed connector fields, which varies according to the connector type.
 */

const AttackDiscoveryScheduleActionParams = exports.AttackDiscoveryScheduleActionParams = _zod.z.object({}).catchall(_zod.z.unknown());
const AttackDiscoveryScheduleActionAlertsFilter = exports.AttackDiscoveryScheduleActionAlertsFilter = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * The condition for throttling the notification: `onActionGroupChange`, `onActiveAlert`,  or `onThrottleInterval`
 */

const AttackDiscoveryScheduleActionNotifyWhen = exports.AttackDiscoveryScheduleActionNotifyWhen = _zod.z.enum(['onActiveAlert', 'onThrottleInterval', 'onActionGroupChange']);
const AttackDiscoveryScheduleActionNotifyWhenEnum = exports.AttackDiscoveryScheduleActionNotifyWhenEnum = AttackDiscoveryScheduleActionNotifyWhen.enum;

/**
 * Defines how often schedule actions are taken. Time interval in seconds, minutes, hours, or days.
 */

const AttackDiscoveryScheduleActionThrottle = exports.AttackDiscoveryScheduleActionThrottle = _zod.z.string().regex(/^[1-9]\d*[smhd]$/);

/**
 * The action frequency defines when the action runs (for example, only on schedule execution or at specific time intervals).
 */

const AttackDiscoveryScheduleActionFrequency = exports.AttackDiscoveryScheduleActionFrequency = _zod.z.object({
  /**
   * Action summary indicates whether we will send a summary notification about all the generate alerts or notification per individual alert
   */
  summary: _zod.z.boolean(),
  notifyWhen: AttackDiscoveryScheduleActionNotifyWhen,
  throttle: AttackDiscoveryScheduleActionThrottle.nullable()
});
const AttackDiscoveryScheduleAction = exports.AttackDiscoveryScheduleAction = _zod.z.object({
  /**
   * The action type used for sending notifications.
   */
  actionTypeId: _zod.z.string(),
  group: AttackDiscoveryScheduleActionGroup.optional(),
  id: AttackDiscoveryScheduleActionId,
  params: AttackDiscoveryScheduleActionParams,
  uuid: _common_attributes2.NonEmptyString.optional(),
  alertsFilter: AttackDiscoveryScheduleActionAlertsFilter.optional(),
  frequency: AttackDiscoveryScheduleActionFrequency.optional()
});

/**
 * An attack discovery schedule execution status
 */

const AttackDiscoveryScheduleExecutionStatus = exports.AttackDiscoveryScheduleExecutionStatus = _zod.z.enum(['ok', 'active', 'error', 'unknown', 'warning']);
const AttackDiscoveryScheduleExecutionStatusEnum = exports.AttackDiscoveryScheduleExecutionStatusEnum = AttackDiscoveryScheduleExecutionStatus.enum;

/**
 * An attack discovery schedule execution information
 */

const AttackDiscoveryScheduleExecution = exports.AttackDiscoveryScheduleExecution = _zod.z.object({
  /**
   * Date of the execution
   */
  date: _zod.z.string().datetime(),
  /**
   * Duration of the execution
   */
  duration: _zod.z.number().optional(),
  /**
   * Status of the execution
   */
  status: AttackDiscoveryScheduleExecutionStatus,
  message: _zod.z.string().optional()
});

/**
 * An attack discovery schedule
 */

const AttackDiscoverySchedule = exports.AttackDiscoverySchedule = _zod.z.object({
  /**
   * UUID of attack discovery schedule
   */
  id: _zod.z.string(),
  /**
   * The name of the schedule
   */
  name: _zod.z.string(),
  /**
   * The name of the user that created the schedule
   */
  createdBy: _zod.z.string(),
  /**
   * The name of the user that updated the schedule
   */
  updatedBy: _zod.z.string(),
  /**
   * The date the schedule was created
   */
  createdAt: _zod.z.string().datetime(),
  /**
   * The date the schedule was updated
   */
  updatedAt: _zod.z.string().datetime(),
  /**
   * Indicates whether the schedule is enabled
   */
  enabled: _zod.z.boolean(),
  /**
   * The attack discovery schedule configuration parameters
   */
  params: AttackDiscoveryScheduleParams,
  /**
   * The attack discovery schedule interval
   */
  schedule: IntervalSchedule,
  /**
   * The attack discovery schedule actions
   */
  actions: _zod.z.array(AttackDiscoveryScheduleAction),
  /**
   * The attack discovery schedule last execution summary
   */
  lastExecution: AttackDiscoveryScheduleExecution.optional()
});

/**
 * An attack discovery schedule create properties
 */

const AttackDiscoveryScheduleCreateProps = exports.AttackDiscoveryScheduleCreateProps = _zod.z.object({
  /**
   * The name of the schedule
   */
  name: _zod.z.string(),
  /**
   * Indicates whether the schedule is enabled
   */
  enabled: _zod.z.boolean().optional(),
  /**
   * The attack discovery schedule configuration parameters
   */
  params: AttackDiscoveryScheduleParams,
  /**
   * The attack discovery schedule interval
   */
  schedule: IntervalSchedule,
  /**
   * The attack discovery schedule actions
   */
  actions: _zod.z.array(AttackDiscoveryScheduleAction).optional()
});

/**
 * An attack discovery schedule update properties
 */

const AttackDiscoveryScheduleUpdateProps = exports.AttackDiscoveryScheduleUpdateProps = _zod.z.object({
  /**
   * The name of the schedule
   */
  name: _zod.z.string(),
  /**
   * The attack discovery schedule configuration parameters
   */
  params: AttackDiscoveryScheduleParams,
  /**
   * The attack discovery schedule interval
   */
  schedule: IntervalSchedule,
  /**
   * The attack discovery schedule actions
   */
  actions: _zod.z.array(AttackDiscoveryScheduleAction)
});