"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collectReferencesDeep = collectReferencesDeep;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MAX_BULK_GET_SIZE = 10000;
async function collectReferencesDeep(savedObjectClient, objects) {
  let result = [];
  const queue = [...objects];
  while (queue.length !== 0) {
    const itemsToGet = queue.splice(0, MAX_BULK_GET_SIZE);
    const {
      saved_objects: savedObjects
    } = await savedObjectClient.bulkGet(itemsToGet);
    result = result.concat(savedObjects);
    for (const {
      references = []
    } of savedObjects) {
      for (const reference of references) {
        const isDuplicate = queue.concat(result).some(obj => obj.type === reference.type && obj.id === reference.id);
        if (isDuplicate) {
          continue;
        }
        queue.push({
          type: reference.type,
          id: reference.id
        });
      }
    }
  }
  return result;
}