"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampTableCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DATE_FORMAT = 'dateFormat';
const TimestampTableCell = ({
  timestamp
}) => {
  const dateFormat = (0, _public.useUiSetting)(DEFAULT_DATE_FORMAT);
  const formatted = (0, _eui.formatDate)(timestamp, dateFormat);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: formatted
  }, /*#__PURE__*/_react.default.createElement("span", null, (0, _moment.default)(timestamp).fromNow()));
};
exports.TimestampTableCell = TimestampTableCell;