"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUserActionsSubClient = void 0;
var _get = require("./get");
var _connectors = require("./connectors");
var _stats = require("./stats");
var _users = require("./users");
var _find = require("./find");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * API for interacting the actions performed by a user when interacting with the cases entities.
 */

/**
 * Creates an API object for interacting with the user action entities
 */
const createUserActionsSubClient = (clientArgs, casesClient) => {
  const attachmentSubClient = {
    find: params => (0, _find.find)(params, casesClient, clientArgs),
    getAll: params => (0, _get.get)(params, clientArgs),
    getConnectors: params => (0, _connectors.getConnectors)(params, clientArgs),
    stats: params => (0, _stats.getStats)(params, casesClient, clientArgs),
    getUsers: params => (0, _users.getUsers)(params, casesClient, clientArgs)
  };
  return Object.freeze(attachmentSubClient);
};
exports.createUserActionsSubClient = createUserActionsSubClient;