"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _confirm_modal = require("../confirm_modal");
var _routing = require("../routing");
var _workpad = require("../../routes/workpad");
var _page_preview = require("../page_preview");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getAddPageTooltip: () => _i18n.i18n.translate('xpack.canvas.pageManager.addPageTooltip', {
    defaultMessage: 'Add a new page to this workpad'
  }),
  getConfirmRemoveTitle: () => _i18n.i18n.translate('xpack.canvas.pageManager.confirmRemoveTitle', {
    defaultMessage: 'Remove Page'
  }),
  getConfirmRemoveDescription: () => _i18n.i18n.translate('xpack.canvas.pageManager.confirmRemoveDescription', {
    defaultMessage: 'Are you sure you want to remove this page?'
  }),
  getConfirmRemoveButtonLabel: () => _i18n.i18n.translate('xpack.canvas.pageManager.removeButtonLabel', {
    defaultMessage: 'Remove'
  })
};
class PageManager extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_activePageRef", null);
    (0, _defineProperty2.default)(this, "_pageListRef", null);
    (0, _defineProperty2.default)(this, "scrollToActivePage", () => {
      if (this._activePageRef && this._pageListRef) {
        // not all target browsers support element.scrollTo
        // TODO: replace this with something more cross-browser, maybe scrollIntoView
        if (!this._pageListRef.scrollTo) {
          return;
        }
        const pageOffset = this._activePageRef.offsetLeft;
        const {
          left: pageLeft,
          right: pageRight,
          width: pageWidth
        } = this._activePageRef.getBoundingClientRect();
        const {
          left: listLeft,
          right: listRight,
          width: listWidth
        } = this._pageListRef.getBoundingClientRect();
        if (pageLeft < listLeft) {
          this._pageListRef.scrollTo({
            left: pageOffset,
            behavior: 'smooth'
          });
        }
        if (pageRight > listRight) {
          this._pageListRef.scrollTo({
            left: pageOffset - listWidth + pageWidth,
            behavior: 'smooth'
          });
        }
      }
    });
    (0, _defineProperty2.default)(this, "onConfirmRemove", removeId => {
      if (this._isMounted) {
        this.setState({
          removeId
        });
      }
    });
    (0, _defineProperty2.default)(this, "resetRemove", () => this._isMounted && this.setState({
      removeId: null
    }));
    (0, _defineProperty2.default)(this, "doRemove", () => {
      const {
        onRemovePage
      } = this.props;
      const {
        removeId
      } = this.state;
      this.resetRemove();
      if (removeId !== null) {
        onRemovePage(removeId);
      }
    });
    (0, _defineProperty2.default)(this, "onDragEnd", ({
      draggableId: pageId,
      source,
      destination
    }) => {
      // dropped outside the list
      if (!destination) {
        return;
      }
      const position = destination.index - source.index;
      this.props.onMovePage(pageId, position);
    });
    (0, _defineProperty2.default)(this, "renderPage", (page, i) => {
      const {
        isWriteable,
        selectedPage
      } = this.props;
      const pageNumber = i + 1;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
        key: page.id,
        draggableId: page.id,
        index: i,
        isDragDisabled: !isWriteable,
        className: `canvasPageManager__page ${page.id === selectedPage ? 'canvasPageManager__page-isActive' : ''}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        className: "canvasPageManager__pageNumber"
      }, pageNumber)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_workpad.WorkpadRoutingContext.Consumer, null, ({
        getUrl
      }) => /*#__PURE__*/_react.default.createElement(_routing.RoutingLink, {
        to: getUrl(pageNumber)
      }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_page_preview.PagePreview, {
        height: 100,
        page: page,
        onRemove: this.onConfirmRemove
      })))))));
    });
    this.state = {
      showTrayPop: true,
      removeId: null
    };
  }
  componentDidMount() {
    // keep track of whether or not the component is mounted, to prevent rogue setState calls
    this._isMounted = true;

    // gives the tray pop animation time to finish
    setTimeout(() => {
      this.scrollToActivePage();
      if (this._isMounted) {
        this.setState({
          showTrayPop: false
        });
      }
    }, 1000);
  }
  componentDidUpdate(prevProps) {
    // scrolls to the active page on the next tick, otherwise new pages don't scroll completely into view
    if (prevProps.selectedPage !== this.props.selectedPage) {
      setTimeout(this.scrollToActivePage, 0);
    }
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    const {
      pages,
      onAddPage,
      isWriteable
    } = this.props;
    const {
      showTrayPop,
      removeId
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      className: "canvasPageManager"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "canvasPageManager__pages"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
      onDragEnd: this.onDragEnd
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
      droppableId: "droppable-page-manager",
      grow: true,
      direction: "horizontal"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: `canvasPageManager__pageList ${showTrayPop ? 'canvasPageManager--trayPop' : ''}`
    }, pages.map(this.renderPage))))), isWriteable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      anchorClassName: "canvasPageManager__addPageTip",
      content: strings.getAddPageTooltip(),
      position: "left"
    }, /*#__PURE__*/_react.default.createElement("button", {
      onClick: onAddPage,
      className: "canvasPageManager__addPage kbn-resetFocusState",
      "data-test-subj": "canvasAddPageButton"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "ghost",
      type: "plusInCircle",
      size: "l"
    }))))), /*#__PURE__*/_react.default.createElement(_confirm_modal.ConfirmModal, {
      isOpen: removeId !== null,
      title: strings.getConfirmRemoveTitle(),
      message: strings.getConfirmRemoveDescription(),
      confirmButtonText: strings.getConfirmRemoveButtonLabel(),
      onConfirm: this.doRemove,
      onCancel: this.resetRemove
    }));
  }
}
exports.PageManager = PageManager;
(0, _defineProperty2.default)(PageManager, "propTypes", {
  isWriteable: _propTypes.default.bool.isRequired,
  onAddPage: _propTypes.default.func.isRequired,
  onMovePage: _propTypes.default.func.isRequired,
  onPreviousPage: _propTypes.default.func.isRequired,
  onRemovePage: _propTypes.default.func.isRequired,
  pages: _propTypes.default.array.isRequired,
  selectedPage: _propTypes.default.string,
  workpadCSS: _propTypes.default.string,
  workpadId: _propTypes.default.string.isRequired
});