"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildSFProps = exports.specComponentFactory = void 0;
exports.useSpecFactory = useSpecFactory;
const react_1 = require("react");
const react_redux_1 = require("react-redux");
const specs_1 = require("../state/actions/specs");
const common_1 = require("../utils/common");
function useSpecFactory(props) {
    const dispatch = (0, react_redux_1.useDispatch)();
    (0, react_1.useEffect)(() => {
        dispatch((0, specs_1.upsertSpec)(props));
    });
    (0, react_1.useEffect)(() => () => {
        dispatch((0, specs_1.removeSpec)(props.id));
    }, []);
}
const specComponentFactory = () => (overrides, defaults) => {
    return (props) => {
        useSpecFactory({ ...defaults, ...(0, common_1.stripUndefined)(props), ...overrides });
        return null;
    };
};
exports.specComponentFactory = specComponentFactory;
const buildSFProps = () => (overrides, defaults) => ({
    overrides,
    defaults,
    optionals: {},
    requires: {},
});
exports.buildSFProps = buildSFProps;
//# sourceMappingURL=spec_factory.js.map