"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getInitialState = void 0;
const get_initial_pointer_state_1 = require("./utils/get_initial_pointer_state");
const get_initial_tooltip_state_1 = require("./utils/get_initial_tooltip_state");
const default_settings_spec_1 = require("../specs/default_settings_spec");
const getInitialState = (chartId, title, description) => ({
    chartId,
    title,
    description,
    zIndex: 0,
    specsInitialized: false,
    specParsing: false,
    chartRendered: false,
    chartRenderedCount: 0,
    specs: {
        [default_settings_spec_1.DEFAULT_SETTINGS_SPEC.id]: default_settings_spec_1.DEFAULT_SETTINGS_SPEC,
    },
    colors: {
        temporary: {},
        persisted: {},
    },
    chartType: null,
    interactions: {
        pointer: (0, get_initial_pointer_state_1.getInitialPointerState)(),
        highlightedLegendPath: [],
        deselectedDataSeries: [],
        hoveredDOMElement: null,
        drilldown: [],
        prevDrilldown: [],
        tooltip: (0, get_initial_tooltip_state_1.getInitialTooltipState)(),
    },
    externalEvents: {
        pointer: null,
    },
    parentDimensions: {
        height: 0,
        width: 0,
        left: 0,
        top: 0,
    },
});
exports.getInitialState = getInitialState;
//# sourceMappingURL=get_initial_state.js.map