# frozen_string_literal: true

class Views::FritoPie::Home::Index < ::Views::Base
  needs :server_props

  def content
    doctype!
    html(:lang => 'en', :class => 'no-js') do
      head do
        title('Elastic Workplace Search')
        widget Views::Shared::Favicon, :product => 'workplace-search'
        common_meta_tags

        stylesheet_packs_with_chunks_tag('eui')
        stylesheet_link_tag('es/main')
        javascript_packs_with_chunks_tag('workplace_search')
      end
      widget Views::FritoPie::Components::Icons
      body(:class => 'layout layout--app') do
        react(
          'App',
          :props => server_props,
          :class => 'app'
        )
      end
    end
  end
end
