/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.embed;

import java.io.PrintStream;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackLogger;
import org.jruby.rack.embed.Config;
import org.jruby.rack.logging.OutputStreamLogger;

public class Context
implements RackContext,
RackLogger {
    private final String serverInfo;
    private final Config config;
    private RackLogger logger;
    private RackLogger.Level level;

    public Context(String serverInfo) {
        this(serverInfo, new Config());
    }

    public Context(String serverInfo, Config config) {
        if (config == null) {
            throw new IllegalArgumentException("null config");
        }
        this.serverInfo = serverInfo;
        this.config = config;
        this.logger = config.getLogger();
        if (this.logger == null) {
            this.logger = new DefaultLogger();
        }
    }

    @Override
    public String getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    public RackLogger.Level getLevel() {
        return this.level;
    }

    public void setLevel(RackLogger.Level level) {
        this.level = level;
    }

    @Override
    public void log(String message) {
        this.logger.log(message);
    }

    @Override
    public void log(String message, Throwable ex) {
        this.logger.log(message, ex);
    }

    @Override
    public void log(RackLogger.Level level, String message) {
        if (this.isEnabled(level)) {
            this.logger.log(level, message);
        }
    }

    @Override
    public void log(RackLogger.Level level, String message, Throwable ex) {
        if (this.isEnabled(level)) {
            this.logger.log(level, message, ex);
        }
    }

    @Override
    @Deprecated
    public void log(String level, String message) {
        this.log(RackLogger.Level.valueOf(level), message);
    }

    @Override
    @Deprecated
    public void log(String level, String message, Throwable ex) {
        this.log(RackLogger.Level.valueOf(level), message, ex);
    }

    @Override
    public boolean isEnabled(RackLogger.Level level) {
        if (level == null || this.level == null) {
            return true;
        }
        return this.level.ordinal() <= level.ordinal();
    }

    private class DefaultLogger
    extends RackLogger.Base {
        private DefaultLogger() {
        }

        @Override
        public void log(RackLogger.Level level, String message) {
            PrintStream out = Context.this.config.getOut();
            out.print((Object)level);
            out.print(": ");
            OutputStreamLogger.printMessage(out, message);
        }

        @Override
        public void log(RackLogger.Level level, String message, Throwable ex) {
            PrintStream err = Context.this.config.getErr();
            err.print((Object)level);
            err.print(": ");
            OutputStreamLogger.printMessage(err, message);
            ex.printStackTrace(err);
        }

        @Override
        public boolean isEnabled(RackLogger.Level level) {
            return true;
        }

        @Override
        public RackLogger.Level getLevel() {
            return null;
        }
    }
}

