/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.thumbnails4j.docx;

import co.elastic.thumbnails4j.core.Dimensions;
import co.elastic.thumbnails4j.core.ThumbnailUtils;
import co.elastic.thumbnails4j.core.Thumbnailer;
import co.elastic.thumbnails4j.core.ThumbnailingException;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLConverter;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOCXThumbnailer
implements Thumbnailer {
    Logger logger = LoggerFactory.getLogger(DOCXThumbnailer.class);

    public List<BufferedImage> getThumbnails(File input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileInputStream fis = new FileInputStream(input);){
                return this.getThumbnails(fis, dimensions);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("Could not find file {}", (Object)input.getAbsolutePath());
            this.logger.error("With stack: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new ThumbnailingException((Exception)e);
        }
    }

    public List<BufferedImage> getThumbnails(InputStream input, List<Dimensions> dimensions) throws ThumbnailingException {
        ArrayList<BufferedImage> results = new ArrayList<BufferedImage>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (XWPFDocument docx = new XWPFDocument(input);){
                InputStream imageStream = docx.getProperties().getThumbnailImage();
                if (imageStream == null) {
                    byte[] htmlBytes = this.htmlBytesFromDocx(docx);
                    for (Dimensions singleDimension : dimensions) {
                        Dimensions expectedDimensions = this.docxPageDimensions(docx, singleDimension);
                        BufferedImage image = ThumbnailUtils.scaleHtmlToImage((byte[])htmlBytes, (Dimensions)expectedDimensions);
                        results.add(ThumbnailUtils.scaleImage((BufferedImage)image, (Dimensions)singleDimension));
                    }
                } else {
                    BufferedImage image = ImageIO.read(imageStream);
                    for (Dimensions singleDimension : dimensions) {
                        results.add(ThumbnailUtils.scaleImage((BufferedImage)image, (Dimensions)singleDimension));
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to read thumbnails from DOCX", (Throwable)e);
            throw new ThumbnailingException((Exception)e);
        }
        return results;
    }

    private Dimensions docxPageDimensions(XWPFDocument docx, Dimensions dimensions) {
        CTPageSz pageSz = null;
        try {
            pageSz = docx.getDocument().getBody().getSectPr().getPgSz();
        }
        catch (NullPointerException nullPointerException) {
            this.logger.debug("No page size detected for DOCX document");
        }
        if (pageSz == null) {
            return dimensions;
        }
        return new Dimensions(((BigInteger)pageSz.getW()).intValue(), ((BigInteger)pageSz.getH()).intValue());
    }

    private byte[] htmlBytesFromDocx(XWPFDocument docx) throws IOException {
        ByteArrayOutputStream htmlStream = new ByteArrayOutputStream();
        XHTMLConverter.getInstance().convert(docx, (OutputStream)htmlStream, null);
        return htmlStream.toByteArray();
    }
}

