# frozen_string_literal: true
class Views::SharedTogo::AuthBody < ::Views::Base
  needs(:view_title)
  needs(:product_icon => 'shared/products/icon-elastic.svg')
  needs(:product_version => AppConfig.product_version)
  needs(:documentation_url => nil)

  def content(&block)
    body(:class => 'enterprise-search-home enterprise-search-home--auth') do
      widget Views::Stui::Components::Icons
      widget Views::SharedTogo::HomeHeader
      div(:class => 'euiPage') do
        div(:class => 'euiPageBody') do
          div(:class => 'euiPageContent euiPageContent--verticalCenter euiPageContent--horizontalCenter') do
            section(:class => 'euiPanel auth-container') do
              header(:class => 'auth-container__header') do
                div(:class => 'euiFlexGroup euiFlexGroup--gutterMedium euiFlexGroup--alignItemsCenter') do
                  image_tag(product_icon, :class => 'euiFlexItem euiFlexItem--flexGrowZero euiIcon euiIcon--xxLarge euiIcon--app euiCard__icon')
                  div(:class => 'euiFlexItem') do
                    h1(:class => 'euiTitle euiTitle--small') do
                      span('Elastic')
                      span(" #{view_title}", :class => 'euiTextColor euiTextColor--subdued')
                    end
                    unless AppConfig.hide_version_info?
                      div(:class => 'euiText euiText--extraSmall') do
                        p("Version #{product_version}", :class => 'euiTextColor euiTextColor--subdued')
                      end
                    end
                  end
                end
              end
              if flash[:notice]
                div(:class => 'euiCallOut euiCallOut--primary', :'data-type' => 'flash') do
                  div(:class => 'euiCallOutHeader') do
                    eui_icon(:information, :class => 'euiIcon euiIcon--medium euiCallOutHeader__icon')
                    span(flash[:notice], :class => 'euiCallOutHeader__title')
                  end
                end
                div(:class => 'euiSpacer euiSpacer--l')
              end
              div(:class => 'auth-container__content', &block)
              footer(:class => 'auth-container__footer') do
                text('Need help getting started? ')
                a('Visit the documentation', :href => SharedTogo.documentation_url, :class => 'euiLink euiLink--primary', :target => '_blank', :rel => 'noopener')
              end
            end
          end
          footer(:class => 'legal') do
            div(:class => 'euiText euiText--extraSmall euiTextAlign--center euiTextColor euiTextColor--subdued') do
              text("© #{Time.current.year}. All Rights Reserved. Elasticsearch")
              br
              text('Elasticsearch is a trademark of Elasticsearch BV, registered in the U.S. and in other countries.')
            end
          end
        end
      end
    end
  end
end
