# frozen_string_literal: true
#
# This exists as a widget since fortitude blows up when trying
# to put the call to csrf_meta_tags inside head() since it tries
# to output a text tag instead of a meta tag, only in specs.
#
# The odd thing is that our development environment works just fine.
# I don't know what's causing that.
#
# Playing around with a few different options, changing
# ActionView::Helpers::CsrfHelper#csrf_meta_tags to have
# tag(:meta) instead of tag('meta') does the correct thing, but
# I don't want to monkey patch ActionView, and figuring out
# the bug with fortitude appears to be rather time consuming.
#
# I also tried setting `enforce_element_nesting_rules false` inside
# Views::FritoPie::Base, and moving this `def content` implementation
# there, which also worked, but that feels like even more of a hack.
#
# Finally, csrf_meta_tags should be in the head as defined here:
# http://api.rubyonrails.org/classes/ActionController/RequestForgeryProtection.html
#
class Views::Shared::CommonMetaTags < ::Views::Base
  def content
    csrf_meta_tags
    meta(:content => 'text/html; charset=UTF-8', 'http-equiv' => 'Content-Type')
    meta(:charset => 'utf-8')
    meta(:content => 'width=device-width, initial-scale=1, user-scalable=no', :name => 'viewport')
    meta(:name => 'product-version', :content => AppConfig.product_version)
    if user_signed_in? && SharedTogo.elasticsearch.has_kibana_access?(current_user.elasticsearch_auth_header)
      meta(:name => 'kibana-url', :content => SharedTogo.kibana_external_base_url)
    end
  end
end
