/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jruby.rack.RackConfig;
import org.jruby.rack.servlet.RewindableInputStream;

public class RequestCapture
extends HttpServletRequestWrapper {
    private Map<String, String[]> requestParams;
    private RewindableInputStream inputStream;

    public RequestCapture(HttpServletRequest request) {
        super(request);
    }

    @Deprecated
    public RequestCapture(HttpServletRequest request, RackConfig config) {
        this(request);
    }

    public BufferedReader getReader() throws IOException {
        String enc = this.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), enc));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new RewindableInputStream((InputStream)super.getInputStream());
        }
        return this.inputStream;
    }

    public String getParameter(String name) {
        if (this.requestParametersParsed()) {
            String[] values = this.requestParams.get(name);
            if (values != null) {
                return values[0];
            }
            return null;
        }
        return super.getParameter(name);
    }

    public Map getParameterMap() {
        if (this.requestParametersParsed()) {
            return this.requestParams;
        }
        return super.getParameterMap();
    }

    public Enumeration getParameterNames() {
        if (this.requestParametersParsed()) {
            return new Enumeration(){
                Iterator keys;
                {
                    this.keys = RequestCapture.this.requestParams.keySet().iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.keys.hasNext();
                }

                public Object nextElement() {
                    return this.keys.next();
                }
            };
        }
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (this.requestParametersParsed()) {
            return this.requestParams.get(name);
        }
        return super.getParameterValues(name);
    }

    private boolean parseRequestParams() {
        if (this.requestParams != null) {
            return true;
        }
        if (!"application/x-www-form-urlencoded".equals(super.getContentType())) {
            return false;
        }
        String line = "";
        try {
            line = this.getReader().readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (line == null) {
            return false;
        }
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String[] pairs = line.split("\\&");
        for (int i = 0; i < pairs.length; ++i) {
            try {
                String[] newValues;
                String[] fields = pairs[i].split("=", 2);
                String key = URLDecoder.decode(fields[0], "UTF-8");
                String value = null;
                if (fields.length == 2) {
                    value = URLDecoder.decode(fields[1], "UTF-8");
                }
                if (value == null) continue;
                if (params.containsKey(key)) {
                    String[] values = (String[])params.get(key);
                    newValues = new String[values.length + 1];
                    System.arraycopy(values, 0, newValues, 0, values.length);
                    newValues[values.length] = value;
                } else {
                    newValues = new String[]{value};
                }
                params.put(key, newValues);
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.requestParams = params;
        return true;
    }

    private boolean requestParametersParsed() {
        return this.parseRequestParams() && this.requestParams.size() >= super.getParameterMap().size();
    }

    public void reset() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.rewind();
        }
    }

    public boolean isInputAccessed() {
        return this.inputStream != null;
    }
}

