/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import org.jruby.rack.RackLogger;

public class OutputStreamLogger
extends RackLogger.Base {
    private final PrintStream out;
    private RackLogger.Level level;
    private boolean formatting = true;

    public OutputStreamLogger(OutputStream out) {
        this(new PrintStream(out));
    }

    public OutputStreamLogger(PrintStream out) {
        if (out == null) {
            throw new IllegalArgumentException("no stream");
        }
        this.out = out;
    }

    @Override
    public RackLogger.Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(RackLogger.Level level) {
        this.level = level;
    }

    @Override
    public void log(String message) {
        this.doLog(message);
    }

    @Override
    public void log(String message, Throwable ex) {
        this.doLog(message, ex);
    }

    @Override
    public void log(RackLogger.Level level, String message) {
        if (!this.isEnabled(level)) {
            return;
        }
        OutputStreamLogger.printLevel(this, level, this.out);
        this.doLog(message);
    }

    private void doLog(CharSequence message) {
        OutputStreamLogger.printMessage(this.out, message);
        this.out.flush();
    }

    @Override
    public void log(RackLogger.Level level, String message, Throwable ex) {
        if (!this.isEnabled(level)) {
            return;
        }
        OutputStreamLogger.printLevel(this, level, this.out);
        this.doLog(message, ex);
    }

    private void doLog(String message, Throwable ex) {
        OutputStreamLogger.printMessage(this.out, message);
        ex.printStackTrace(this.out);
        this.out.flush();
    }

    @Override
    public boolean isEnabled(RackLogger.Level level) {
        if (level == null || this.level == null) {
            return true;
        }
        return this.level.ordinal() <= level.ordinal();
    }

    @Override
    public boolean isFormatting() {
        return this.formatting;
    }

    @Override
    public void setFormatting(boolean formatting) {
        this.formatting = formatting;
    }

    public static void printLevel(RackLogger.Base logger, RackLogger.Level level, PrintStream out) {
        if (logger.isFormatting()) {
            out.print((Object)level);
            out.print(": ");
        }
    }

    public static void printMessage(PrintStream out, CharSequence message) {
        if (message.charAt(message.length() - 1) == '\n') {
            out.print(message);
        } else {
            out.println(message);
        }
    }
}

