/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack;

import org.jruby.Ruby;
import org.jruby.RubyObjectAdapter;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.rack.RackApplication;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.RackResponse;
import org.jruby.runtime.builtin.IRubyObject;

public class DefaultRackApplication
implements RackApplication {
    protected final RubyObjectAdapter adapter = JavaEmbedUtils.newObjectAdapter();
    protected IRubyObject application;

    public DefaultRackApplication() {
    }

    public DefaultRackApplication(IRubyObject application) {
        this();
        this.setApplication(application);
    }

    @Override
    public RackResponse call(RackEnvironment env) {
        IRubyObject app = this.getApplication();
        Ruby runtime = this.getRuntime();
        IRubyObject servlet_env = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)env);
        IRubyObject response = app.callMethod(runtime.getCurrentContext(), "call", servlet_env);
        return (RackResponse)response.toJava(RackResponse.class);
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Ruby getRuntime() {
        return this.getApplication().getRuntime();
    }

    public IRubyObject getApplication() {
        if (this.application == null) {
            throw new IllegalStateException("no application set");
        }
        return this.application;
    }

    public void setApplication(IRubyObject application) {
        this.application = application;
    }

    public boolean isApplicationSet() {
        return this.application != null;
    }
}

