/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.thumbnails4j.doc;

import co.elastic.thumbnails4j.core.Dimensions;
import co.elastic.thumbnails4j.core.ThumbnailUtils;
import co.elastic.thumbnails4j.core.Thumbnailer;
import co.elastic.thumbnails4j.core.ThumbnailingException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.model.SEPX;
import org.apache.poi.hwpf.model.SectionTable;
import org.apache.poi.hwpf.usermodel.SectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOCThumbnailer
implements Thumbnailer {
    private static Logger logger = LoggerFactory.getLogger(DOCThumbnailer.class);

    public List<BufferedImage> getThumbnails(File input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileInputStream fis = new FileInputStream(input);){
                return this.getThumbnails(fis, dimensions);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find file {}", (Object)input.getAbsolutePath());
            logger.error("With stack: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new ThumbnailingException((Exception)e);
        }
    }

    public List<BufferedImage> getThumbnails(InputStream input, List<Dimensions> dimensions) throws ThumbnailingException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (HWPFDocument document = new HWPFDocument(input);){
                byte[] htmlBytes = this.htmlBytesFromDoc(document);
                BufferedImage image = ThumbnailUtils.scaleHtmlToImage((byte[])htmlBytes, (Dimensions)this.docPageDimensions(document));
                ArrayList<BufferedImage> results = new ArrayList<BufferedImage>();
                for (Dimensions singleDimension : dimensions) {
                    results.add(ThumbnailUtils.scaleImage((BufferedImage)image, (Dimensions)singleDimension));
                }
                return results;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            logger.error("Could not parse MS Word Document from input stream");
            logger.error("With stack: ", (Throwable)e);
            throw new ThumbnailingException(e);
        }
    }

    private byte[] htmlBytesFromDoc(HWPFDocument document) throws ParserConfigurationException, TransformerException {
        WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
        wordToHtmlConverter.processDocument((HWPFDocumentCore)document);
        Document html_document = wordToHtmlConverter.getDocument();
        this.add_margins_to_html(html_document);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DOMSource domSource = new DOMSource(html_document);
            StreamResult streamResult = new StreamResult(out);
            ThumbnailUtils.getTransformerForXhtmlDOM().transform(domSource, streamResult);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error("Possible resource leak - a problem occurred while closing the stream", (Throwable)e);
            }
        }
        return out.toByteArray();
    }

    private void add_margins_to_html(Document html_document) {
        Node body = html_document.getElementsByTagName("body").item(0);
        Element page_div = html_document.createElement("div");
        page_div.setAttribute("style", "width:595.4pt;margin-bottom:36.0pt;margin-top:36.0pt;margin-left:36.0pt;margin-right:36.0pt;");
        while (body.getFirstChild() != null) {
            page_div.appendChild(body.removeChild(body.getFirstChild()));
        }
        body.appendChild(page_div);
    }

    private Dimensions docPageDimensions(HWPFDocument document) {
        SectionTable st = document.getSectionTable();
        List sections = st.getSections();
        SectionProperties sectionProperties = ((SEPX)sections.get(0)).getSectionProperties();
        return new Dimensions(sectionProperties.getXaPage(), sectionProperties.getYaPage());
    }
}

