/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.matchers;

import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.datageneration.matchers.GenericEqualsMatcher;
import org.elasticsearch.datageneration.matchers.MatchResult;
import org.elasticsearch.datageneration.matchers.source.SourceMatcher;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class Matcher {
    public static <T> SettingsStep<T> mappings(XContentBuilder actualMappings, XContentBuilder expectedMappings) {
        return new Builder(expectedMappings, actualMappings);
    }

    public static MappingsStep<List<Map<String, Object>>> matchSource() {
        return new SourceMatcherBuilder();
    }

    private static class Builder<T>
    implements SettingsStep<T>,
    CompareStep<T>,
    ExpectedStep<T> {
        private final XContentBuilder expectedMappings;
        private final XContentBuilder actualMappings;
        private Settings.Builder expectedSettings;
        private Settings.Builder actualSettings;
        private T expected;
        private T actual;
        private boolean ignoringSort;

        @Override
        public ExpectedStep<T> settings(Settings.Builder actualSettings, Settings.Builder expectedSettings) {
            this.actualSettings = actualSettings;
            this.expectedSettings = expectedSettings;
            return this;
        }

        private Builder(XContentBuilder actualMappings, XContentBuilder expectedMappings) {
            this.actualMappings = actualMappings;
            this.expectedMappings = expectedMappings;
        }

        @Override
        public MatchResult isEqualTo(T actual) {
            return new GenericEqualsMatcher<T>(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, actual, this.expected, this.ignoringSort).match();
        }

        @Override
        public CompareStep<T> ignoringSort(boolean ignoringSort) {
            this.ignoringSort = ignoringSort;
            return this;
        }

        @Override
        public CompareStep<T> expected(T expected) {
            this.expected = expected;
            return this;
        }
    }

    private static class SourceMatcherBuilder
    implements MappingsStep<List<Map<String, Object>>>,
    SettingsStep<List<Map<String, Object>>>,
    CompareStep<List<Map<String, Object>>>,
    ExpectedStep<List<Map<String, Object>>> {
        private Map<String, Map<String, Object>> mappingLookup;
        private XContentBuilder expectedMappings;
        private XContentBuilder actualMappings;
        private Settings.Builder expectedSettings;
        private Settings.Builder actualSettings;
        private List<Map<String, Object>> expected;
        private boolean ignoringSort;

        @Override
        public ExpectedStep<List<Map<String, Object>>> settings(Settings.Builder actualSettings, Settings.Builder expectedSettings) {
            this.actualSettings = actualSettings;
            this.expectedSettings = expectedSettings;
            return this;
        }

        private SourceMatcherBuilder() {
        }

        @Override
        public SettingsStep<List<Map<String, Object>>> mappings(Map<String, Map<String, Object>> mappingLookup, XContentBuilder actualMappings, XContentBuilder expectedMappings) {
            this.mappingLookup = mappingLookup;
            this.actualMappings = actualMappings;
            this.expectedMappings = expectedMappings;
            return this;
        }

        @Override
        public MatchResult isEqualTo(List<Map<String, Object>> actual) {
            return new SourceMatcher(this.mappingLookup, this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, actual, this.expected, this.ignoringSort).match();
        }

        @Override
        public CompareStep<List<Map<String, Object>>> ignoringSort(boolean ignoringSort) {
            this.ignoringSort = ignoringSort;
            return this;
        }

        @Override
        public CompareStep<List<Map<String, Object>>> expected(List<Map<String, Object>> expected) {
            this.expected = expected;
            return this;
        }
    }

    public static interface CompareStep<T> {
        public MatchResult isEqualTo(T var1);

        public CompareStep<T> ignoringSort(boolean var1);
    }

    public static interface ExpectedStep<T> {
        public CompareStep<T> expected(T var1);
    }

    public static interface SettingsStep<T> {
        public ExpectedStep<T> settings(Settings.Builder var1, Settings.Builder var2);
    }

    public static interface MappingsStep<T> {
        public SettingsStep<T> mappings(Map<String, Map<String, Object>> var1, XContentBuilder var2, XContentBuilder var3);
    }
}

