/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.request.v1;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.cohere.CohereAccount;
import org.elasticsearch.xpack.inference.services.cohere.request.CohereRequest;
import org.elasticsearch.xpack.inference.services.cohere.rerank.CohereRerankModel;
import org.elasticsearch.xpack.inference.services.cohere.rerank.CohereRerankTaskSettings;

public class CohereV1RerankRequest
extends CohereRequest {
    private final String query;
    private final List<String> input;
    private final Boolean returnDocuments;
    private final Integer topN;
    private final CohereRerankTaskSettings taskSettings;

    public CohereV1RerankRequest(String query, List<String> input, @Nullable Boolean returnDocuments, @Nullable Integer topN, CohereRerankModel model) {
        super(CohereAccount.of(model), model.getInferenceEntityId(), model.getServiceSettings().modelId(), false);
        this.input = Objects.requireNonNull(input);
        this.query = Objects.requireNonNull(query);
        this.returnDocuments = returnDocuments;
        this.topN = topN;
        this.taskSettings = model.getTaskSettings();
    }

    @Override
    protected List<String> pathSegments() {
        return List.of("v1", "rerank");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("model", this.getModelId());
        builder.field("query", this.query);
        builder.field("documents", this.input);
        if (this.returnDocuments != null) {
            builder.field("return_documents", this.returnDocuments);
        } else if (this.taskSettings.getDoesReturnDocuments() != null) {
            builder.field("return_documents", this.taskSettings.getDoesReturnDocuments());
        }
        if (this.topN != null) {
            builder.field("top_n", this.topN);
        } else if (this.taskSettings.getTopNDocumentsOnly() != null) {
            builder.field("top_n", this.taskSettings.getTopNDocumentsOnly());
        }
        if (this.taskSettings.getMaxChunksPerDoc() != null) {
            builder.field("max_chunks_per_doc", this.taskSettings.getMaxChunksPerDoc());
        }
        builder.endObject();
        return builder;
    }
}

