/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.repositories.RepositoryConflictException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;

@ServerlessScope(value=Scope.INTERNAL)
public class RestDeleteRepositoryAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_snapshot/{repository}"));
    }

    @Override
    public String getName() {
        return "delete_repository_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String name = request.param("repository");
        DeleteRepositoryRequest deleteRepositoryRequest = new DeleteRepositoryRequest(RestUtils.getMasterNodeTimeout(request), RestUtils.getAckTimeout(request), name);
        return channel -> client.admin().cluster().deleteRepository(deleteRepositoryRequest, new RestToXContentListener((RestChannel)channel).delegateResponse((delegate, err) -> {
            if (request.getRestApiVersion().equals((Object)RestApiVersion.V_7) && err instanceof RepositoryConflictException) {
                delegate.onFailure(new IllegalStateException(((RepositoryConflictException)err).getBackwardCompatibleMessage()));
            } else {
                delegate.onFailure((Exception)err);
            }
        }));
    }
}

