/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

public class BQSpaceUtils {
    public static final short B_QUERY = 4;

    public static void transposeHalfByte(byte[] q, byte[] quantQueryByte) {
        int i = 0;
        while (i < q.length) {
            assert (q[i] >= 0 && q[i] <= 15);
            int lowerByte = 0;
            int lowerMiddleByte = 0;
            int upperMiddleByte = 0;
            int upperByte = 0;
            for (int j = 7; j >= 0 && i < q.length; ++i, --j) {
                lowerByte |= (q[i] & 1) << j;
                lowerMiddleByte |= (q[i] >> 1 & 1) << j;
                upperMiddleByte |= (q[i] >> 2 & 1) << j;
                upperByte |= (q[i] >> 3 & 1) << j;
            }
            int index = (i + 7) / 8 - 1;
            quantQueryByte[index] = (byte)lowerByte;
            quantQueryByte[index + quantQueryByte.length / 4] = (byte)lowerMiddleByte;
            quantQueryByte[index + quantQueryByte.length / 2] = (byte)upperMiddleByte;
            quantQueryByte[index + 3 * quantQueryByte.length / 4] = (byte)upperByte;
        }
    }
}

