/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.retriever;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RankDocsQueryBuilder;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.retriever.CompoundRetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilderWrapper;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.EnterpriseSearch;
import org.elasticsearch.xpack.application.rules.RuleQueryBuilder;
import org.elasticsearch.xpack.application.rules.retriever.RuleQueryRankDoc;
import org.elasticsearch.xpack.core.XPackPlugin;

public final class QueryRuleRetrieverBuilder
extends CompoundRetrieverBuilder<QueryRuleRetrieverBuilder> {
    public static final String NAME = "rule";
    public static final NodeFeature QUERY_RULE_RETRIEVERS_SUPPORTED = new NodeFeature("query_rule_retriever_supported", true);
    public static final ParseField RULESET_IDS_FIELD = new ParseField("ruleset_ids", new String[0]);
    public static final ParseField MATCH_CRITERIA_FIELD = new ParseField("match_criteria", new String[0]);
    public static final ParseField RETRIEVER_FIELD = new ParseField("retriever", new String[0]);
    public static final ConstructingObjectParser<QueryRuleRetrieverBuilder, RetrieverParserContext> PARSER = new ConstructingObjectParser("rule", args -> {
        List rulesetIds = (List)args[0];
        Map matchCriteria = (Map)args[1];
        RetrieverBuilder retrieverBuilder = (RetrieverBuilder)args[2];
        int rankWindowSize = args[3] == null ? 10 : (Integer)args[3];
        return new QueryRuleRetrieverBuilder(rulesetIds, matchCriteria, retrieverBuilder, rankWindowSize);
    });
    private final List<String> rulesetIds;
    private final Map<String, Object> matchCriteria;

    public static QueryRuleRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        if (!context.clusterSupportsFeature(QUERY_RULE_RETRIEVERS_SUPPORTED)) {
            throw new ParsingException(parser.getTokenLocation(), "unknown retriever [rule]", new Object[0]);
        }
        if (!EnterpriseSearch.QUERY_RULES_RETRIEVER_FEATURE.check(XPackPlugin.getSharedLicenseState())) {
            throw LicenseUtils.newComplianceException((String)"Query Rules");
        }
        try {
            return (QueryRuleRetrieverBuilder)((Object)PARSER.apply(parser, (Object)context));
        }
        catch (Exception e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public QueryRuleRetrieverBuilder(List<String> rulesetIds, Map<String, Object> matchCriteria, RetrieverBuilder retrieverBuilder, int rankWindowSize) {
        super(new ArrayList(), rankWindowSize);
        this.rulesetIds = rulesetIds;
        this.matchCriteria = matchCriteria;
        this.addChild((RetrieverBuilder)new QueryRuleRetrieverBuilderWrapper(retrieverBuilder));
    }

    public QueryRuleRetrieverBuilder(List<String> rulesetIds, Map<String, Object> matchCriteria, List<CompoundRetrieverBuilder.RetrieverSource> retrieverSource, int rankWindowSize, String retrieverName, List<QueryBuilder> preFilterQueryBuilders) {
        super(retrieverSource, rankWindowSize);
        this.rulesetIds = rulesetIds;
        this.matchCriteria = matchCriteria;
        this.retrieverName = retrieverName;
        this.preFilterQueryBuilders = preFilterQueryBuilders;
    }

    public String getName() {
        return NAME;
    }

    protected SearchSourceBuilder finalizeSourceBuilder(SearchSourceBuilder source) {
        QueryRuleRetrieverBuilder.checkValidSort(source.sorts());
        source.query((QueryBuilder)new RuleQueryBuilder(source.query(), this.matchCriteria, this.rulesetIds));
        return source;
    }

    private static void checkValidSort(List<SortBuilder<?>> sortBuilders) {
        if (sortBuilders.isEmpty()) {
            return;
        }
        if (!(sortBuilders.get(0) instanceof ScoreSortBuilder)) {
            throw new IllegalArgumentException("[rule] retriever only supports sort by score, got: " + String.valueOf(sortBuilders));
        }
    }

    public void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.array(RULESET_IDS_FIELD.getPreferredName(), this.rulesetIds.toArray());
        builder.startObject(MATCH_CRITERIA_FIELD.getPreferredName());
        builder.mapContents(this.matchCriteria);
        builder.endObject();
        builder.field(RETRIEVER_FIELD.getPreferredName(), (ToXContent)((CompoundRetrieverBuilder.RetrieverSource)this.innerRetrievers.get(0)).retriever());
        builder.field(RANK_WINDOW_SIZE_FIELD.getPreferredName(), this.rankWindowSize);
    }

    protected QueryRuleRetrieverBuilder clone(List<CompoundRetrieverBuilder.RetrieverSource> newChildRetrievers, List<QueryBuilder> newPreFilterQueryBuilders) {
        return new QueryRuleRetrieverBuilder(this.rulesetIds, this.matchCriteria, newChildRetrievers, this.rankWindowSize, this.retrieverName, newPreFilterQueryBuilders);
    }

    protected RankDoc[] combineInnerRetrieverResults(List<ScoreDoc[]> rankResults, boolean explain) {
        assert (rankResults.size() == 1);
        ScoreDoc[] scoreDocs = rankResults.get(0);
        RankDoc[] rankDocs = new RuleQueryRankDoc[scoreDocs.length];
        for (int i = 0; i < scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = scoreDocs[i];
            rankDocs[i] = explain ? new RuleQueryRankDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex, this.rulesetIds, this.matchCriteria) : new RuleQueryRankDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex);
            rankDocs[i].rank = i + 1;
        }
        return rankDocs;
    }

    public boolean doEquals(Object o) {
        QueryRuleRetrieverBuilder that = (QueryRuleRetrieverBuilder)((Object)o);
        return super.doEquals(o) && Objects.equals(this.rulesetIds, that.rulesetIds) && Objects.equals(this.matchCriteria, that.matchCriteria);
    }

    public int doHashCode() {
        return Objects.hash(super.doHashCode(), this.rulesetIds, this.matchCriteria);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), RULESET_IDS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), MATCH_CRITERIA_FIELD);
        PARSER.declareNamedObject(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            RetrieverBuilder innerRetriever = (RetrieverBuilder)p.namedObject(RetrieverBuilder.class, n, c);
            c.trackRetrieverUsage(innerRetriever.getName());
            return innerRetriever;
        }, RETRIEVER_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_WINDOW_SIZE_FIELD);
        RetrieverBuilder.declareBaseParserFields((String)NAME, PARSER);
    }

    class QueryRuleRetrieverBuilderWrapper
    extends RetrieverBuilderWrapper<QueryRuleRetrieverBuilderWrapper> {
        protected QueryRuleRetrieverBuilderWrapper(RetrieverBuilder in) {
            super(in);
        }

        protected QueryRuleRetrieverBuilderWrapper clone(RetrieverBuilder in) {
            return new QueryRuleRetrieverBuilderWrapper(in);
        }

        public QueryBuilder topDocsQuery() {
            return new RuleQueryBuilder(this.in.topDocsQuery(), QueryRuleRetrieverBuilder.this.matchCriteria, QueryRuleRetrieverBuilder.this.rulesetIds);
        }

        public QueryBuilder explainQuery() {
            return new RankDocsQueryBuilder(this.in.getRankDocs(), new QueryBuilder[]{new RuleQueryBuilder(this.in.explainQuery(), QueryRuleRetrieverBuilder.this.matchCriteria, QueryRuleRetrieverBuilder.this.rulesetIds)}, true);
        }
    }
}

