/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorNameAction {
    public static final String NAME = "indices:data/write/xpack/connector/update_name";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/update_name");

    private UpdateConnectorNameAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        @Nullable
        private final String name;
        @Nullable
        private final String description;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_name_request", false, (args, connectorId) -> new Request((String)connectorId, (String)args[0], (String)args[1]));

        public Request(String connectorId, String name, String description) {
            this.connectorId = connectorId;
            this.name = name;
            this.description = description;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.name = in.readOptionalString();
            this.description = in.readOptionalString();
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            if (this.name == null && this.description == null) {
                validationException = ValidateActions.addValidationError((String)"[name] and [description] cannot both be [null]. Please provide a value for at least one of them.", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.name != null) {
                builder.field(Connector.NAME_FIELD.getPreferredName(), this.name);
            }
            if (this.description != null) {
                builder.field(Connector.DESCRIPTION_FIELD.getPreferredName(), this.description);
            }
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeOptionalString(this.name);
            out.writeOptionalString(this.description);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.name, request.name) && Objects.equals(this.description, request.description);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.name, this.description);
        }

        static {
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Connector.NAME_FIELD);
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Connector.DESCRIPTION_FIELD);
        }
    }
}

