/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class EntryRebalancingRequestAccessLogMessage
extends AccessLogMessage {
    private static final long serialVersionUID = -7183383454122018479L;
    @Nullable
    private final Integer sizeLimit;
    @Nullable
    private final Long rebalancingOperationID = this.getNamedValueAsLong("rebalancingOp");
    @Nullable
    private final Long triggeringConnectionID;
    @Nullable
    private final Long triggeringOperationID;
    @Nullable
    private final String sourceBackendSetName;
    @Nullable
    private final String sourceBackendServer;
    @Nullable
    private final String subtreeBaseDN;
    @Nullable
    private final String targetBackendSetName;
    @Nullable
    private final String targetBackendServer;

    public EntryRebalancingRequestAccessLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public EntryRebalancingRequestAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        this.sizeLimit = this.getNamedValueAsInteger("sizeLimit");
        this.sourceBackendServer = this.getNamedValue("sourceServer");
        this.sourceBackendSetName = this.getNamedValue("sourceBackendSet");
        this.subtreeBaseDN = this.getNamedValue("base");
        this.targetBackendServer = this.getNamedValue("targetServer");
        this.targetBackendSetName = this.getNamedValue("targetBackendSet");
        this.triggeringConnectionID = this.getNamedValueAsLong("triggeredByConn");
        this.triggeringOperationID = this.getNamedValueAsLong("triggeredByOp");
    }

    @Nullable
    public final Long getRebalancingOperationID() {
        return this.rebalancingOperationID;
    }

    @Nullable
    public final Long getTriggeringConnectionID() {
        return this.triggeringConnectionID;
    }

    @Nullable
    public final Long getTriggeringOperationID() {
        return this.triggeringOperationID;
    }

    @Nullable
    public final String getSubtreeBaseDN() {
        return this.subtreeBaseDN;
    }

    @Nullable
    public final Integer getSizeLimit() {
        return this.sizeLimit;
    }

    @Nullable
    public final String getSourceBackendSetName() {
        return this.sourceBackendSetName;
    }

    @Nullable
    public final String getSourceBackendServer() {
        return this.sourceBackendServer;
    }

    @Nullable
    public final String getTargetBackendSetName() {
        return this.targetBackendSetName;
    }

    @Nullable
    public final String getTargetBackendServer() {
        return this.targetBackendServer;
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.ENTRY_REBALANCING_REQUEST;
    }
}

