/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search.extractor;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;

public class CompositeKeyExtractor
implements BucketExtractor {
    static final String NAME = "k";
    private final String key;
    private final boolean isDateTimeBased;

    public CompositeKeyExtractor(String key, boolean isDateTimeBased) {
        this.key = key;
        this.isDateTimeBased = isDateTimeBased;
    }

    CompositeKeyExtractor(StreamInput in) throws IOException {
        this.key = in.readString();
        this.isDateTimeBased = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.key);
        out.writeBoolean(this.isDateTimeBased);
    }

    public String key() {
        return this.key;
    }

    public String getWriteableName() {
        return NAME;
    }

    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        Object m = bucket.getKey();
        if (!(m instanceof Map)) {
            throw new EqlIllegalArgumentException("Unexpected bucket returned: {}", m);
        }
        Object object = ((Map)m).get(this.key);
        if (this.isDateTimeBased) {
            if (object == null) {
                return object;
            }
            if (object instanceof Long) {
                return object;
            }
            throw new EqlIllegalArgumentException("Invalid date key returned: {}", object);
        }
        return object;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.isDateTimeBased);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeKeyExtractor other = (CompositeKeyExtractor)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.isDateTimeBased, other.isDateTimeBased);
    }

    public String toString() {
        return "|" + this.key + "|";
    }
}

